/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.get.streamproducers;

import fr.exemole.bdfserver.api.instruction.BdfParameters;
import fr.exemole.bdfserver.html.BdfServerHtmlProducer;
import java.text.DecimalFormatSymbols;
import java.util.Collection;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.exportation.table.ColDef;
import net.fichotheque.exportation.table.SubsetTable;
import net.fichotheque.exportation.table.SumCellConverter;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.format.SourceLabelProvider;
import net.fichotheque.tools.exportation.table.TableExportEngine;
import net.fichotheque.utils.TableDefUtils;
import net.mapeadores.util.html.HtmlTableWriter;
import net.mapeadores.util.localisation.Lang;

public class TableExportHtmlProducer
extends BdfServerHtmlProducer {
    private final SubsetTable subsetTable;
    private final Collection<SubsetItem> subsetItems;
    private final String headerType;
    private final boolean fragment;
    private final TableExportContext tableExportContext;
    private final SumCellConverter sumCellConverter;

    public TableExportHtmlProducer(BdfParameters bdfParameters, SubsetTable subsetTable, Collection<SubsetItem> subsetItems, String headerType, boolean fragment, TableExportContext tableExportContext, SumCellConverter sumCellConverter) {
        super(bdfParameters);
        this.subsetTable = subsetTable;
        this.subsetItems = subsetItems;
        this.headerType = headerType;
        this.fragment = fragment;
        this.tableExportContext = tableExportContext;
        this.sumCellConverter = sumCellConverter;
        this.setReversePath("../");
    }

    @Override
    public void printHtml() {
        if (!this.fragment) {
            this.start();
        }
        this.TABLE();
        Subset subset = this.subsetTable.getSubset();
        switch (this.headerType) {
            case "columntitle": {
                this.printHeaderTitle(this.subsetTable, this.workingLang, subset);
                break;
            }
            case "columnkey": {
                this.printHeaderKey(this.subsetTable);
            }
        }
        HtmlTableWriter htmlTableWriter = new HtmlTableWriter(this, new DecimalFormatSymbols(this.bdfUser.getFormatLocale()));
        TableExportEngine.exportSubset(this.subsetTable, htmlTableWriter, this.sumCellConverter, this.subsetItems);
        this._TABLE();
        if (!this.fragment) {
            this.end();
        }
    }

    private void printHeaderTitle(SubsetTable table, Lang workingLang, Subset subset) {
        SourceLabelProvider sourceLabelProvider = this.tableExportContext.getSourceLabelProvider();
        this.TR();
        for (ColDef colDef : table.getColDefList()) {
            this.TH().__escape(TableDefUtils.getColTitle(colDef, workingLang, sourceLabelProvider, subset))._TH();
        }
        this._TR();
    }

    private void printHeaderKey(SubsetTable table) {
        this.TR();
        for (ColDef colDef : table.getColDefList()) {
            this.TH().__escape(colDef.getColName())._TH();
        }
        this._TR();
    }
}

