/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.ExistingSubsetException;
import net.fichotheque.SubsetKey;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.sphere.SphereEditor;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SphereCreationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SphereCreation";
    public static final String COMMANDKEY = "_ SPH-01";
    public static final String NEWSPHERE_PARAMNAME = "newsphere";
    private SubsetKey sphereKey;

    public SphereCreationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        Sphere sphere;
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            try {
                SphereEditor sphereEditor = session.getFichothequeEditor().createSphere(this.sphereKey);
                sphere = sphereEditor.getSphere();
            }
            catch (ExistingSubsetException ese) {
                throw new ShouldNotOccurException("test before ExistingSubsetException");
            }
        }
        this.putResultObject("obj.sphere", sphere);
        this.setDone("_ done.sphere.spherecreation", this.sphereKey.getKeyString());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        String nameParam = this.getMandatory(NEWSPHERE_PARAMNAME);
        nameParam = nameParam.trim();
        if (nameParam.length() == 0) {
            throw BdfErrors.error("_ error.empty.spherename");
        }
        try {
            this.sphereKey = SubsetKey.parse((short)3, nameParam);
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.spherename", nameParam);
        }
        if (this.fichotheque.containsSubset(this.sphereKey)) {
            throw BdfErrors.error("_ error.existing.sphere", nameParam);
        }
    }
}

