/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.users.BdfUserPrefs;
import fr.exemole.bdfserver.api.users.BdfUserPrefsEditor;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.text.ParseException;
import java.util.Locale;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LangPreferenceBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class RedacteurLangCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurLang";
    public static final String COMMANDKEY = "_ USR-02";
    public static final String WORKINGLANG_PARAMNAME = "workinglang";
    public static final String CUSTOMFORMATLOCALE_PARAMNAME = "customformatlocale";
    public static final String CUSTOMLANGPREFERENCE_PARAMNAME = "customlangpreference";
    private Lang workingLang;
    private Locale customFormatLocale;
    private LangPreference customLangPreference;
    private BdfUserPrefs redacBdfUserPrefs;

    public RedacteurLangCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            BdfUserPrefsEditor bdfUserPrefsEditor = session.getBdfServerEditor().getBdfUserPrefsEditor(this.redacBdfUserPrefs);
            bdfUserPrefsEditor.setWorkingLang(this.workingLang);
            bdfUserPrefsEditor.setCustomFormatLocale(this.customFormatLocale);
            bdfUserPrefsEditor.setCustomLangPreference(this.customLangPreference);
        }
        this.setDone("_ done.sphere.redacteurlang", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String preferenceString;
        Redacteur redacteur = this.requestHandler.getMandatoryRedacteur();
        boolean isSame = BdfUserUtils.isSame(this.bdfUser, redacteur);
        if (!isSame) {
            this.checkSubsetAdmin(redacteur.getSphere());
        }
        this.redacBdfUserPrefs = isSame ? this.bdfUser.getPrefs() : this.bdfServer.createBdfUser(redacteur).getPrefs();
        String workingLangParam = this.getMandatory(WORKINGLANG_PARAMNAME);
        try {
            this.workingLang = Lang.parse(workingLangParam);
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(WORKINGLANG_PARAMNAME, workingLangParam);
        }
        if (!this.bdfServer.getLangConfiguration().getWorkingLangs().contains(this.workingLang)) {
            throw BdfErrors.unknownParameterValue(WORKINGLANG_PARAMNAME, workingLangParam);
        }
        String formatLocaleString = this.getMandatory(CUSTOMFORMATLOCALE_PARAMNAME).trim();
        if (formatLocaleString.length() > 0) {
            try {
                Lang formatLang = Lang.parse(formatLocaleString);
                this.customFormatLocale = formatLang.toLocale();
            }
            catch (ParseException lie) {
                throw BdfErrors.error("_ error.wrong.customformatlocale", formatLocaleString);
            }
        }
        if ((preferenceString = this.getMandatory(CUSTOMLANGPREFERENCE_PARAMNAME).trim()).length() > 0) {
            String[] tokens;
            LangPreferenceBuilder langPreferenceBuilder = new LangPreferenceBuilder();
            for (String token : tokens = StringUtils.getTechnicalTokens(preferenceString, true)) {
                try {
                    Lang lang = Lang.parse(token);
                    langPreferenceBuilder.addLang(lang);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (!langPreferenceBuilder.isEmpty()) {
                this.customLangPreference = langPreferenceBuilder.toLangPreference();
            } else {
                throw BdfErrors.error("_ error.wrong.customlangpreference");
            }
        }
    }
}

