/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.sphere;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.sphere.Redacteur;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class RedacteurAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RedacteurAttributeChange";
    public static final String COMMANDKEY = "_ SPH-09";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Redacteur redacteur;
    private AttributeChange attributeChange;

    public RedacteurAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("sphere", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.redacteur, this.attributeChange);
        }
        this.putResultObject("obj.sphere", this.redacteur.getSphere());
        this.putResultObject("obj.redacteur", this.redacteur);
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.redacteur = this.requestHandler.getMandatoryRedacteur();
        this.checkSubsetAdmin(this.redacteur.getSphere());
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

