/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.importation;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.commands.importation.AbstractImportParseCommand;
import fr.exemole.bdfserver.tools.importation.ImportationFileUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.io.File;
import java.io.IOException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.importation.CorpusImport;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.directory.CorpusImportSave;
import net.fichotheque.tools.importation.parsers.CorpusRowParser;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.parsers.FicheParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class CorpusImportParseCommand
extends AbstractImportParseCommand {
    public static final String COMMANDNAME = "CorpusImportParse";
    public static final String COMMANDKEY = "_ IMP-01";
    public static final String TYPE_PARAMNAME = "type";
    private String parseType;
    private Corpus corpus;

    public CorpusImportParseCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        FicheParser.Parameters ficheParserParameters = new FicheParser.Parameters(this.bdfUser, this.bdfServer.getL10nManager().getCodeCatalog(), this.getHtmlCleaner(), BdfUserUtils.getTypoOptions(this.bdfUser));
        ficheParserParameters.setUserRedacteur(this.bdfUser.getRedacteur());
        ParseResultBuilder parseResultBuilder = new ParseResultBuilder("corpusimport");
        CorpusRowParser rowParser = CorpusRowParser.newInstance(this.fieldsArray, this.parseType, this.corpus, parseResultBuilder, ficheParserParameters, this.bdfServer.getPolicyManager().getPolicyProvider(), this.bdfServer.getThesaurusLangChecker());
        if (rowParser != null) {
            for (int i = 0; i < this.lines.length; ++i) {
                Object line = this.lines[i];
                if (((String[])line).length == 0) continue;
                rowParser.parseRow(i + 1, new Row((String[])line));
            }
            CorpusImport corpusImport = rowParser.getCorpusImportBuilder().toCorpusImport();
            try {
                switch (corpusImport.getType()) {
                    case "edit": {
                        File tmpDir = ImportationFileUtils.createTmpDir(this.bdfServer, "corpusimport");
                        CorpusImportSave.save(corpusImport, tmpDir);
                        parseResultBuilder.setPath(tmpDir.getName());
                        break;
                    }
                    default: {
                        File tmpFile = ImportationFileUtils.saveTmpXml(this.bdfServer, corpusImport);
                        parseResultBuilder.setPath(tmpFile.getName());
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                throw BdfErrors.ioException(ioe);
            }
        }
        this.putResultObject("obj.parseresult", parseResultBuilder.toParseResult());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.requestHandler.enableStore();
        String typeParam = this.getMandatory(TYPE_PARAMNAME);
        try {
            typeParam = CorpusRowParser.checkType(typeParam);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(TYPE_PARAMNAME, typeParam);
        }
        this.parseType = typeParam;
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkLines();
        this.requestHandler.store("form_import_corpus");
    }
}

