/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.corpus.Corpus;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.StringUtils;

public class UiComponentPositionCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "UiComponentPosition";
    public static final String COMMANDKEY = "_ CRP-18";
    public static final String COMPONENTPOSITION_PARAMNAME = "componentposition";
    private String componentPosition;
    private Corpus corpus;

    public UiComponentPositionCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        boolean done;
        String[] tokens = StringUtils.getLineTokens(this.componentPosition, (short)2);
        int count = tokens.length;
        for (int i = 0; i < count; ++i) {
            tokens[i] = UiComponentPositionCommand.clean(tokens[i]);
        }
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            done = session.getBdfServerEditor().setPositionArray(this.bdfServer.getUiManager().getMainUiComponents(this.corpus), tokens);
        }
        this.putResultObject("obj.corpus", this.corpus);
        if (done) {
            this.setDone("_ done.corpus.uicomponentposition", new Object[0]);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        this.componentPosition = this.getMandatory(COMPONENTPOSITION_PARAMNAME);
    }

    private static String clean(String token) {
        char carac;
        int length = token.length();
        StringBuilder buf = new StringBuilder(length * 2);
        for (int i = 0; i < length && (carac = token.charAt(i)) != ' ' && carac != '('; ++i) {
            buf.append(carac);
        }
        return buf.toString();
    }
}

