/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.ExistingFieldKeyException;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class SoustitreActivationCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "SoustitreActivation";
    public static final String COMMANDKEY = "_ CRP-02";
    private Corpus corpus;

    public SoustitreActivationCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            CorpusMetadataEditor corpusMetadataEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus).getCorpusMetadataEditor();
            try {
                corpusMetadataEditor.createCorpusField(FieldKey.SOUSTITRE, (short)0);
            }
            catch (ExistingFieldKeyException efke) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.setDone("_ done.corpus.soustitreactivation", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        if (this.corpus.getCorpusMetadata().isWithSoustitre()) {
            throw BdfErrors.error("_ error.existing.fieldkey_soustitre");
        }
    }
}

