/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.MandatoryFieldException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class FieldRemoveCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "FieldRemove";
    public static final String COMMANDKEY = "_ CRP-08";
    public static final String FIELDKEY_PARAMNAME = "fieldkey";
    private Corpus corpus;
    private CorpusField corpusField;

    public FieldRemoveCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        String key;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            CorpusMetadataEditor corpusMetadataEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus).getCorpusMetadataEditor();
            try {
                key = this.corpusField.getFieldString();
                corpusMetadataEditor.removeCorpusField(this.corpusField);
            }
            catch (MandatoryFieldException mfe) {
                throw new ShouldNotOccurException("test done before");
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.setDone("_ done.corpus.fieldremove", key);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        String fieldKeyValue = this.getMandatory(FIELDKEY_PARAMNAME);
        fieldKeyValue = fieldKeyValue.trim();
        if (fieldKeyValue.length() == 0) {
            throw BdfErrors.error("_ error.empty.fieldkey");
        }
        FieldKey fieldKey = null;
        try {
            fieldKey = FieldKey.parse(fieldKeyValue);
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(FIELDKEY_PARAMNAME, fieldKeyValue);
        }
        this.corpusField = this.corpus.getCorpusMetadata().getCorpusField(fieldKey);
        if (this.corpusField == null || fieldKey.isMandatoryField()) {
            throw BdfErrors.wrongParameterValue(FIELDKEY_PARAMNAME, fieldKeyValue);
        }
        if (!this.checkConfirmation()) {
            throw BdfErrors.error("_ error.empty.confirmationcheck_remove");
        }
    }
}

