/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.corpus;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfCommandUtils;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.CorpusEditor;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.CorpusMetadataEditor;
import net.fichotheque.corpus.metadata.ExistingFieldKeyException;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.FieldOptionException;
import net.fichotheque.tools.conversion.fieldtofield.FieldToFieldConverter;
import net.fichotheque.tools.corpus.CorpusTools;
import net.fichotheque.tools.corpus.FieldGenerationEngine;
import net.mapeadores.util.exceptions.ImplementationException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.logging.CommandMessageBuilder;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.logging.MessageLogBuilder;
import net.mapeadores.util.logging.MultiMessageHandler;
import net.mapeadores.util.request.RequestMap;

public class ConversionCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "Conversion";
    public static final String COMMANDKEY = "_ CRP-22";
    public static final String FIELD_PARAMNAME = "field";
    public static final String NEWCATEGORY_PARAMNAME = "newcategory";
    public static final String NEWNAME_PARAMNAME = "newname";
    private Corpus corpus;
    private CorpusField sourceField;
    private FieldKey newFieldKey;

    public ConversionCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        MessageLogBuilder messageLogBuilder = new MessageLogBuilder();
        int ficheCount = 0;
        try (EditSession session = this.startEditSession("corpus", COMMANDNAME);){
            CorpusField newCorpusField = null;
            CorpusEditor corpusEditor = session.getFichothequeEditor().getCorpusEditor(this.corpus);
            CorpusMetadataEditor corpusMetadataEditor = corpusEditor.getCorpusMetadataEditor();
            try {
                short ficheItemType = this.getFicheItemType();
                newCorpusField = corpusMetadataEditor.createCorpusField(this.newFieldKey, ficheItemType);
                if (newCorpusField.isInformation() && this.sourceField.isSection()) {
                    corpusMetadataEditor.setFieldOption(newCorpusField, "informationDisplay", "block");
                }
            }
            catch (ExistingFieldKeyException efke) {
                throw new ShouldNotOccurException("test before ExistingSubsetException");
            }
            catch (FieldOptionException foe) {
                throw new ImplementationException(foe);
            }
            FieldToFieldConverter fieldToFieldConverter = FieldToFieldConverter.getInstance(this.sourceField, newCorpusField, (MultiMessageHandler)messageLogBuilder);
            FieldGenerationEngine engine = BdfCommandUtils.buildEngine(this, this.corpus);
            for (FicheMeta ficheMeta : this.corpus.getFicheMetaList()) {
                Fiche fiche = this.corpus.getFiche(ficheMeta);
                fieldToFieldConverter.convert(ficheMeta, fiche);
                CorpusTools.saveFiche(corpusEditor, ficheMeta, fiche, engine, false);
                ++ficheCount;
            }
        }
        this.putResultObject("obj.corpus", this.corpus);
        this.setCommandMessage(CommandMessageBuilder.init().addLog(messageLogBuilder.toMessageLog()).setDone("_ done.corpus.conversion", this.sourceField.getFieldString(), this.newFieldKey.getKeyString(), ficheCount).toCommandMessage());
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.corpus = this.requestHandler.getMandatoryCorpus();
        this.checkSubsetAdmin(this.corpus);
        CorpusMetadata corpusMetadata = this.corpus.getCorpusMetadata();
        String fieldParamName = this.getMandatory(FIELD_PARAMNAME);
        try {
            FieldKey fieldKey = FieldKey.parse(fieldParamName);
            this.sourceField = corpusMetadata.getCorpusField(fieldKey);
            if (this.sourceField == null) {
                throw BdfErrors.unknownParameterValue(FIELD_PARAMNAME, fieldParamName);
            }
        }
        catch (ParseException pe) {
            throw BdfErrors.wrongParameterValue(FIELD_PARAMNAME, fieldParamName);
        }
        short fieldCategory = this.getFieldCategory();
        String newName = this.getMandatory(NEWNAME_PARAMNAME);
        try {
            this.newFieldKey = FieldKey.parse(fieldCategory, newName);
            if (corpusMetadata.getCorpusField(this.newFieldKey) != null) {
                throw BdfErrors.error("_ error.existing.fieldkey", this.newFieldKey.getKeyString());
            }
            if (this.newFieldKey.isSpecial()) {
                throw BdfErrors.wrongParameterValue(NEWNAME_PARAMNAME, newName);
            }
        }
        catch (ParseException pe) {
            throw BdfErrors.error("_ error.wrong.fieldkey", newName);
        }
    }

    private short getFieldCategory() throws ErrorMessageException {
        String categoryString = this.getMandatory(NEWCATEGORY_PARAMNAME);
        try {
            short category = FieldKey.categoryToShort(categoryString);
            switch (category) {
                case 1: 
                case 2: 
                case 3: {
                    return category;
                }
            }
            throw BdfErrors.wrongParameterValue(NEWCATEGORY_PARAMNAME, categoryString);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(NEWCATEGORY_PARAMNAME, categoryString);
        }
    }

    private short getFicheItemType() {
        if (this.newFieldKey.isSection()) {
            return 0;
        }
        FieldKey sourceFieldKey = this.sourceField.getFieldKey();
        if (sourceFieldKey.isSection()) {
            return 11;
        }
        short current = this.sourceField.getFicheItemType();
        if (current == 0) {
            return 1;
        }
        return current;
    }
}

