/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.configuration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.tools.configuration.ConfigurationUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.storage.StorageUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import net.fichotheque.EditOrigin;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.ini.IniWriter;
import net.mapeadores.util.io.IOUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.RelativePath;

public class OdtLogoChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "OdtLogoChange";
    public static final String COMMANDKEY = "_ CNF-19";
    public static final String FILE_PARAMNAME = "file";
    public static final String HEIGHT_PARAMNAME = "height";
    public static final String WIDTH_PARAMNAME = "width";
    private String width;
    private String height;

    public OdtLogoChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        EditOrigin editOrigin = this.bdfUser.newEditOrigin("configuration", COMMANDNAME);
        Map<String, String> logoMap = ConfigurationUtils.getOdtLogoParameters(this.bdfServer);
        logoMap.put(WIDTH_PARAMNAME, this.width);
        logoMap.put(HEIGHT_PARAMNAME, this.height);
        FileValue fileValue = this.requestHandler.getRequestMap().getFileValue(FILE_PARAMNAME);
        if (fileValue != null) {
            if (fileValue.length() > 0L) {
                String mimeType;
                String name = fileValue.getName();
                MimeTypeResolver mimeTypeResolver = this.bdfServer.getMimeTypeResolver();
                String extension = mimeTypeResolver.getPreferredExtension(mimeType = MimeTypeUtils.getMimeType(mimeTypeResolver, fileValue.getName()));
                if (extension != null) {
                    String path = "images/logo-odt." + extension;
                    RelativePath relativePath = RelativePath.build(path);
                    logoMap.put("path", path);
                    try (InputStream is = fileValue.getInputStream();){
                        StorageUtils.saveResource(this.bdfServer, relativePath, is, editOrigin);
                    }
                    catch (IOException ioe) {
                        throw new NestedIOException(ioe);
                    }
                }
            }
            fileValue.free();
        }
        try (InputStream is = IOUtils.toInputStream(IniWriter.mapToString(logoMap), "UTF-8");){
            StorageUtils.saveResource(this.bdfServer, StorageUtils.LOGO_ODT_INI, is, editOrigin);
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.streamtext_io", ioe.getMessage());
        }
        this.setDone("_ done.configuration.odtlogochange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.checkFichothequeAdmin();
        this.width = this.getMandatory(WIDTH_PARAMNAME);
        this.height = this.getMandatory(HEIGHT_PARAMNAME);
    }
}

