/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.commands.album.IllustrationFileUploadCommand;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.fichotheque.album.Album;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class IllustrationFileDownloadCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "IllustrationFileDownload";
    public static final String COMMANDKEY = "_ ALB-08";
    public static final String URL_PARAMNAME = "url";
    private Album album;
    private String extension;
    private HttpURLConnection httpURLConnection;

    public IllustrationFileDownloadCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return false;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        File tmpFile = null;
        try (InputStream is = this.httpURLConnection.getInputStream();){
            tmpFile = IllustrationFileUploadCommand.saveFile(this.bdfServer, is, this.extension, this.album);
        }
        catch (IOException ioe) {
            throw BdfErrors.ioException(ioe);
        }
        if (tmpFile != null) {
            this.setDone("_ done.album.illustrationfiledownload", new Object[0]);
            this.putResultObject("obj.tmpfile", tmpFile);
            this.putResultObject("obj.album", this.album);
        }
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        URL imageURL;
        this.album = this.requestHandler.getMandatoryAlbum();
        String urlString = this.getMandatory(URL_PARAMNAME);
        try {
            imageURL = new URL(urlString);
        }
        catch (MalformedURLException mue) {
            throw BdfErrors.error("_ error.wrong.url", urlString);
        }
        String protocol = imageURL.getProtocol();
        if (protocol == null || protocol.isEmpty()) {
            throw BdfErrors.error("_ error.wrong.url", urlString);
        }
        switch (protocol) {
            case "http": 
            case "https": {
                break;
            }
            default: {
                throw BdfErrors.error("_ error.unknown.url_protocol", protocol);
            }
        }
        try {
            String format;
            HttpURLConnection urlConnection = (HttpURLConnection)imageURL.openConnection();
            urlConnection.setInstanceFollowRedirects(true);
            urlConnection.connect();
            int code = urlConnection.getResponseCode();
            if (code != 200) {
                throw BdfErrors.error("_ error.exception.url_httpcode", code);
            }
            String mimetype = urlConnection.getContentType();
            if (mimetype != null && !mimetype.equals("application/octet-stream")) {
                int idx = mimetype.indexOf("/");
                format = AlbumUtils.checkExtension("img." + mimetype.substring(idx + 1));
                if (format == null) {
                    throw BdfErrors.error("_ error.unknown.url_mimetype", mimetype);
                }
            } else {
                int idx = urlString.lastIndexOf("/");
                format = AlbumUtils.checkExtension(urlString.substring(idx + 1));
                if (format == null) {
                    throw BdfErrors.error("_ error.wrong.url_imageextension", mimetype);
                }
            }
            this.httpURLConnection = urlConnection;
            this.extension = format;
        }
        catch (IOException ioe) {
            throw BdfErrors.error("_ error.exception.url_io", imageURL);
        }
    }
}

