/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.album;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import net.fichotheque.album.Illustration;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;

public class IllustrationAttributeChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "IllustrationAttributeChange";
    public static final String COMMANDKEY = "_ ALB-12";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Illustration illustration;
    private AttributeChange attributeChange;

    public IllustrationAttributeChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() throws ErrorMessageException {
        try (EditSession session = this.startEditSession("album", COMMANDNAME);){
            session.getFichothequeEditor().changeAttributes(this.illustration, this.attributeChange);
        }
        this.putResultObject("obj.album", this.illustration.getAlbum());
        this.putResultObject("obj.illustration", this.illustration);
        this.setDone("_ done.global.attributechange", new Object[0]);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        this.illustration = this.requestHandler.getMandatoryIllustration();
        this.checkSubsetAdmin(this.illustration.getAlbum());
        String attributes = this.getMandatory(ATTRIBUTES_PARAMNAME);
        this.attributeChange = AttributeParser.parse(attributes);
    }
}

