/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.commands.administration;

import fr.exemole.bdfserver.api.BdfServer;
import fr.exemole.bdfserver.api.BdfServerEditor;
import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.roles.FichePermission;
import fr.exemole.bdfserver.api.roles.Permission;
import fr.exemole.bdfserver.api.roles.Role;
import fr.exemole.bdfserver.api.roles.RoleEditor;
import fr.exemole.bdfserver.tools.BdfServerUtils;
import fr.exemole.bdfserver.tools.instruction.AbstractBdfCommand;
import fr.exemole.bdfserver.tools.instruction.BdfErrors;
import fr.exemole.bdfserver.tools.roles.RoleUtils;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import net.fichotheque.Subset;
import net.fichotheque.SubsetKey;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeParser;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.text.LabelChange;

public class RoleChangeCommand
extends AbstractBdfCommand {
    public static final String COMMANDNAME = "RoleChange";
    public static final String COMMANDKEY = "_ ROL-02";
    public static final String PERMISSION_PARAMNAME = "permission";
    public static final String LEVEL_PARAMSUFFIX = "|level";
    public static final String CREATEFICHE_PARAMSUFFIX = "|createfiche";
    public static final String READFICHE_PARAMSUFFIX = "|readfiche";
    public static final String WRITEFICHE_PARAMSUFFIX = "|writefiche";
    public static final String TITLE_PARAMPREFIX = "title/";
    public static final String ATTRIBUTES_PARAMNAME = "attributes";
    private Role role;
    private LabelChange labelChange;
    private AttributeChange attributeChange;
    private final Map<SubsetKey, Permission> permissionMap = new HashMap<SubsetKey, Permission>();

    public RoleChangeCommand(BdfServer bdfServer, RequestMap requestMap) {
        super(bdfServer, requestMap);
    }

    @Override
    public boolean needSynchronisation() {
        return true;
    }

    @Override
    protected void doCommand() {
        try (EditSession session = this.startEditSession("administration", COMMANDNAME);){
            Subset[] subsetArray;
            BdfServerEditor bdfServerEditor = session.getBdfServerEditor();
            RoleEditor roleEditor = bdfServerEditor.getRoleEditor();
            BdfServerUtils.changeLabels(bdfServerEditor, this.role, this.labelChange);
            if (this.attributeChange != null) {
                BdfServerUtils.changeAttributes(bdfServerEditor, this.role, this.attributeChange);
            }
            for (Subset subset : subsetArray = FichothequeUtils.toSubsetArray(this.fichotheque)) {
                SubsetKey subsetKey = subset.getSubsetKey();
                Permission permission = this.permissionMap.get(subsetKey);
                if (permission != null) {
                    roleEditor.putSubsetPermission(this.role, subsetKey, permission);
                    continue;
                }
                roleEditor.removeSubsetPermission(this.role, subsetKey);
            }
        }
        this.setDone("_ done.administration.rolechange", new Object[0]);
        this.putResultObject("obj.role", this.role);
    }

    @Override
    protected void checkParameters() throws ErrorMessageException {
        String[] permissionArray;
        this.checkFichothequeAdmin();
        this.role = this.requestHandler.getMandatoryRole();
        this.labelChange = this.requestHandler.getLabelChange(TITLE_PARAMPREFIX);
        for (String permission : permissionArray = this.requestHandler.getTokens(PERMISSION_PARAMNAME)) {
            try {
                SubsetKey subsetKey = SubsetKey.parse(permission);
                this.initSubsetPermission(subsetKey);
            }
            catch (ParseException pe) {
                throw BdfErrors.wrongParameterValue(PERMISSION_PARAMNAME, permission);
            }
        }
        String attributes = this.requestHandler.getTrimedParameter(ATTRIBUTES_PARAMNAME);
        if (!attributes.isEmpty()) {
            this.attributeChange = AttributeParser.parse(attributes);
        }
    }

    private void initSubsetPermission(SubsetKey subsetKey) throws ErrorMessageException {
        short level;
        String levelParamName = subsetKey + LEVEL_PARAMSUFFIX;
        String levelString = this.getMandatory(levelParamName);
        FichePermission customPermission = null;
        try {
            level = RoleUtils.levelToShort(levelString);
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(levelParamName, levelString);
        }
        if (level == 2 && subsetKey.isCorpusSubset()) {
            short write;
            short read;
            boolean create = this.requestHandler.isTrue(subsetKey + CREATEFICHE_PARAMSUFFIX);
            FichePermission fichePermission = RoleUtils.toFichePermission(create, read = this.getType(subsetKey + READFICHE_PARAMSUFFIX), write = this.getType(subsetKey + WRITEFICHE_PARAMSUFFIX));
            if (RoleUtils.matchStandardPermission(fichePermission)) {
                level = 1;
            } else {
                customPermission = fichePermission;
            }
        }
        this.permissionMap.put(subsetKey, RoleUtils.toPermission(level, customPermission));
    }

    private short getType(String paramName) throws ErrorMessageException {
        String fichePermissionString = this.requestHandler.getTrimedParameter(paramName);
        if (fichePermissionString.isEmpty()) {
            throw BdfErrors.emptyMandatoryParameter(paramName);
        }
        try {
            short type = RoleUtils.fichePermissionTypeToShort(fichePermissionString);
            return type;
        }
        catch (IllegalArgumentException iae) {
            throw BdfErrors.wrongParameterValue(paramName, fichePermissionString);
        }
    }
}

