/*
 * Decompiled with CFR 0.152.
 */
package fr.exemole.bdfserver.api;

import fr.exemole.bdfserver.api.EditSession;
import fr.exemole.bdfserver.api.EditSessionListener;
import fr.exemole.bdfserver.api.configuration.LangConfiguration;
import fr.exemole.bdfserver.api.managers.AccessManager;
import fr.exemole.bdfserver.api.managers.BalayageManager;
import fr.exemole.bdfserver.api.managers.ExtensionManager;
import fr.exemole.bdfserver.api.managers.ExternalScriptManager;
import fr.exemole.bdfserver.api.managers.GroupManager;
import fr.exemole.bdfserver.api.managers.JsLibManager;
import fr.exemole.bdfserver.api.managers.L10nManager;
import fr.exemole.bdfserver.api.managers.PasswordManager;
import fr.exemole.bdfserver.api.managers.PermissionManager;
import fr.exemole.bdfserver.api.managers.PolicyManager;
import fr.exemole.bdfserver.api.managers.ScrutariExportManager;
import fr.exemole.bdfserver.api.managers.SelectionManager;
import fr.exemole.bdfserver.api.managers.SqlExportManager;
import fr.exemole.bdfserver.api.managers.TableExportManager;
import fr.exemole.bdfserver.api.managers.TransformationManager;
import fr.exemole.bdfserver.api.managers.TreeManager;
import fr.exemole.bdfserver.api.managers.UiManager;
import fr.exemole.bdfserver.api.storage.BdfUserStorage;
import fr.exemole.bdfserver.api.storage.EditableResourceStorage;
import fr.exemole.bdfserver.api.storage.StorageRoot;
import fr.exemole.bdfserver.api.users.BdfUser;
import fr.exemole.bdfserver.conf.BdfServerDirs;
import fr.exemole.bdfserver.tools.users.BdfUserUtils;
import java.util.Map;
import net.fichotheque.EditOrigin;
import net.fichotheque.Fichotheque;
import net.fichotheque.exportation.table.TableExportContext;
import net.fichotheque.externalsource.ExternalSourceProvider;
import net.fichotheque.format.FormatContext;
import net.fichotheque.importation.ImportationContext;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.thesaurus.metadata.ThesaurusLangChecker;
import net.fichotheque.utils.EditOriginUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.buildinfo.BuildInfo;
import net.mapeadores.util.html.HtmlCleaner;
import net.mapeadores.util.io.DocStream;
import net.mapeadores.util.io.ResourceStorages;
import net.mapeadores.util.jslib.JsAnalyser;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.MessageLog;
import net.mapeadores.util.mimetype.MimeTypeResolver;
import net.mapeadores.util.mimetype.MimeTypeUtils;
import net.mapeadores.util.text.RelativePath;

public interface BdfServer {
    public MessageLog getInitMessageLog();

    public String getName();

    public BdfServerDirs getBdfServerDirs();

    @Nullable
    public Object getContextObject(String var1);

    public Fichotheque getFichotheque();

    public PermissionManager getPermissionManager();

    public PasswordManager getPasswordManager();

    public TransformationManager getTransformationManager();

    public UiManager getUiManager();

    public PolicyManager getPolicyManager();

    public TableExportManager getTableExportManager();

    public SelectionManager getSelectionManager();

    public ScrutariExportManager getScrutariExportManager();

    public SqlExportManager getSqlExportManager();

    public ExtensionManager getExtensionManager();

    public BalayageManager getBalayageManager();

    public ExternalScriptManager getExternalScriptManager();

    public AccessManager getAccessManager();

    public JsLibManager getJsLibManager();

    public BdfUserStorage getBdfUserStorage();

    public GroupManager getGroupManager();

    public TreeManager getTreeManager();

    public L10nManager getL10nManager();

    public JsAnalyser getJsAnalyser();

    public ExternalSourceProvider getExternalSourceProvider();

    public BdfUser createBdfUser(Redacteur var1);

    public LangConfiguration getLangConfiguration();

    public void addEditionSessionListener(EditSessionListener var1);

    public void removeEditionSessionListener(EditSessionListener var1);

    public EditSession initEditSession(EditOrigin var1);

    public TableExportContext getTableExportContext();

    public ImportationContext getImportationContext();

    public ThesaurusLangChecker getThesaurusLangChecker();

    public HtmlCleaner getHtmlCleaner();

    public BuildInfo getBuildInfo();

    public ResourceStorages getResourceStorages();

    public StorageRoot getOutputStorage();

    public StorageRoot getCacheStorage();

    default public FormatContext getFormatContext() {
        return this.getTableExportContext().getFormatContext();
    }

    default public MimeTypeResolver getMimeTypeResolver() {
        Object object = this.getContextObject("mimeTypeResolver");
        if (object != null) {
            return (MimeTypeResolver)object;
        }
        return MimeTypeUtils.DEFAULT_RESOLVER;
    }

    default public DocStream getResourceDocStream(RelativePath relativePath) {
        return this.getResourceStorages().getResourceDocStream(relativePath, this.getMimeTypeResolver());
    }

    default public EditableResourceStorage getVarResourceStorage() {
        return (EditableResourceStorage)this.getResourceStorages().getResourceStorage("var");
    }

    default public EditSession initEditSession(String source) {
        return this.initEditSession(EditOriginUtils.newEditOrigin(source));
    }

    default public EditSession initEditSession(String redacteurGlobalId, String source) {
        return this.initEditSession(EditOriginUtils.newEditOrigin(source, null, redacteurGlobalId));
    }

    default public EditSession initEditSession(BdfUser bdfUser, String source) {
        return this.initEditSession(bdfUser.newEditOrigin(source));
    }

    default public EditSession initEditSession(BdfUser bdfUser, String domain, String commandName) {
        return this.initEditSession(bdfUser.newEditOrigin(domain, commandName));
    }

    default public void store(BdfUser bdfUser, String storeName, String storeKey, String storeValue) {
        if (!BdfUserUtils.isValidStoreKey(storeKey)) {
            throw new IllegalArgumentException("Invalid store key: " + storeKey);
        }
        BdfUserStorage bdfUserStorage = this.getBdfUserStorage();
        Redacteur redacteur = bdfUser.getRedacteur();
        Map<String, String> storeMap = bdfUserStorage.getStoreMap(redacteur, storeName);
        boolean done = false;
        String currentValue = storeMap.get(storeKey);
        if (storeValue == null) {
            if (currentValue != null) {
                storeMap.remove(storeKey);
                done = true;
            }
        } else if (currentValue == null || !currentValue.equals(storeValue)) {
            storeMap.put(storeKey, storeValue);
            done = true;
        }
        if (done) {
            bdfUserStorage.putStoreMap(redacteur, storeName, storeMap);
        }
    }

    default public void store(BdfUser bdfUser, String storeName, Map<String, String> map) {
        BdfUserStorage bdfUserStorage = this.getBdfUserStorage();
        Redacteur redacteur = bdfUser.getRedacteur();
        Map<String, String> storeMap = bdfUserStorage.getStoreMap(redacteur, storeName);
        boolean done = false;
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String storeKey = entry.getKey();
            if (!BdfUserUtils.isValidStoreKey(storeKey)) continue;
            String storeValue = entry.getValue();
            String currentValue = storeMap.get(storeKey);
            if (storeValue == null) {
                if (currentValue == null) continue;
                storeMap.remove(storeKey);
                done = true;
                continue;
            }
            if (currentValue != null && currentValue.equals(storeValue)) continue;
            storeMap.put(storeKey, storeValue);
            done = true;
        }
        if (done) {
            bdfUserStorage.putStoreMap(redacteur, storeName, storeMap);
        }
    }

    default public String getStoredValue(BdfUser bdfUser, String storeName, String storeKey) {
        BdfUserStorage bdfUserStorage = this.getBdfUserStorage();
        Redacteur redacteur = bdfUser.getRedacteur();
        Map<String, String> storeMap = bdfUserStorage.getStoreMap(redacteur, storeName);
        return storeMap.get(storeKey);
    }

    default public Map<String, String> getStoredValues(BdfUser bdfUser, String storeName) {
        BdfUserStorage bdfUserStorage = this.getBdfUserStorage();
        Redacteur redacteur = bdfUser.getRedacteur();
        return bdfUserStorage.getStoreMap(redacteur, storeName);
    }

    default public Lang getDefaultWorkingLang() {
        return (Lang)this.getLangConfiguration().getWorkingLangs().get(0);
    }
}

