/* global Bdf,Overlay,Importation */

Importation.Overlay = {};

Importation.Overlay.showParseResult = function (parseResult) {
    var contentHtml  = "";
    var footerHtml, formAttrs;
    var withError = false;
    var withWarning = false;
    if (parseResult.initErrorArray) {
        withError = true;
        contentHtml += Bdf.render("importation:initerrors", {
            array: parseResult.initErrorArray
        });
    }
    if (parseResult.initWarningArray) {
        withWarning = true;
        contentHtml += Bdf.render("importation:initwarnings", {
            array: parseResult.initWarningArray
        });
    }
    if (parseResult.parseErrorArray) {
        withError = true;
        contentHtml += Bdf.render("importation:parseerrors", {
            array: parseResult.parseErrorArray
        });
    }
    if (parseResult.bdfErrorArray) {
        withError = true;
        contentHtml += Bdf.render("importation:bdferrors", {
            array: parseResult.bdfErrorArray
        });
    }
    if ((parseResult.path)  && ((!withWarning) && (!withError))) {
        formAttrs = {
            action: Bdf.URL + "importation",
            method: "POST"
        };
        contentHtml += Bdf.render("importation:confirm", {
           type: parseResult.type,
           page: Importation.getPageFromType(parseResult.type),
           root: "tmp",
           path: parseResult.path,
           subsetHtml: _getSubsetHtml()
        });
        footerHtml = Bdf.render("bdf:overlay-footer", {
            submit: {
                locKey: '_ submit.importation.confirm'
            }
        });
    }
    Overlay.start({
        header: Bdf.Loc.escape("_ title.importation.confirm"),
        content: contentHtml,
        footer: footerHtml,
        formAttrs: formAttrs
    });
    
    
    function _getSubsetHtml() {
        var $select = $$({_element: "select", subset: "selection"});
        var $option = $select.find("option").filter(":selected"); 
        if ($option.length === 0) {
            return "";
        }
        var subsetText = $option.text();
        return Bdf.render("importation:subset", {
            labelText: Bdf.Loc.get(_getLabelKey($select.attr("name"))),
            subsetText: subsetText
        });
    }
    
    function _getLabelKey(name) {
        switch(name) {
            case "corpus":
                return "_ label.importation.corpus";
            case "thesaurus":
                return "_ label.importation.thesaurus";
            default:
                return "";
        }
    }
    
};
