/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml.handlers;

import java.text.ParseException;
import java.util.Map;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.xml.handlers.ElementHandler;
import org.xml.sax.Attributes;

public class LabelElementHandler
implements ElementHandler {
    private static final Lang UNDETERMINED_LANG = Lang.build("und");
    private Lang lang;
    private final StringBuilder buf = new StringBuilder();
    private int subCount = 0;

    public LabelElementHandler(Attributes attributes, String xpath) throws ErrorMessageException {
        String langString = attributes.getValue("xml:lang");
        if (langString != null && langString.length() > 0) {
            try {
                this.lang = Lang.parse(langString);
            }
            catch (ParseException pe) {
                throw new ErrorMessageException("_ error.wrong.xml.langattributevalue", xpath, langString);
            }
        }
        if (this.lang == null) {
            throw new ErrorMessageException("_ error.empty.xml.attribute", xpath, "xml:lang");
        }
    }

    @Override
    public void processStartElement(String tagname, Attributes attributes) {
        ++this.subCount;
        this.buf.append("<");
        this.buf.append(tagname);
        this.buf.append(">");
    }

    @Override
    public boolean processEndElement(String tagname) {
        if (this.subCount == 0) {
            return true;
        }
        --this.subCount;
        this.buf.append("</");
        this.buf.append(tagname);
        this.buf.append(">");
        return false;
    }

    @Override
    public void processText(char[] ch, int start, int length) {
        this.buf.append(ch, start, length);
    }

    public ElementHandler initSubElementHandler(String tagname, Map attributeMap) {
        return null;
    }

    public void flushSubElementHandler(String tagname, ElementHandler elementHandler) {
    }

    public Label toLabel() {
        CleanedString cleanedString = CleanedString.newInstance(this.buf);
        if (cleanedString == null) {
            return null;
        }
        if (this.lang == null) {
            this.lang = UNDETERMINED_LANG;
        }
        return LabelUtils.toLabel(this.lang, cleanedString);
    }
}

