/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.xml;

import java.io.ByteArrayOutputStream;
import javax.xml.transform.sax.SAXSource;
import net.mapeadores.util.primitives.io.PrimitivesIOFactory;
import net.mapeadores.util.primitives.io.PrimitivesReader;
import net.mapeadores.util.primitives.io.PrimitivesWriter;
import net.mapeadores.util.xml.PrimitivesSAXReader;
import net.mapeadores.util.xml.PrimitivesXMLWriter;
import net.mapeadores.util.xml.XMLWriter;
import org.xml.sax.InputSource;
import org.xml.sax.XMLReader;

public class XMLBuffer {
    private ByteArrayOutputStream byteArrayOutputStream;
    private byte[] byteArray;
    private InputSource inputSource = new InputSource();

    public XMLBuffer() {
        this.byteArrayOutputStream = new ByteArrayOutputStream();
    }

    public XMLWriter getXMLWriter() {
        if (this.byteArrayOutputStream == null) {
            throw new IllegalStateException("flush done before !");
        }
        PrimitivesWriter primitivesWriter = PrimitivesIOFactory.newWriter(this.byteArrayOutputStream);
        return new PrimitivesXMLWriter(primitivesWriter);
    }

    public void flush() {
        this.byteArray = this.byteArrayOutputStream.toByteArray();
        this.byteArrayOutputStream = null;
    }

    private XMLReader getXMLReader() {
        PrimitivesReader primitivesReader = PrimitivesIOFactory.newReader(this.byteArray);
        return new PrimitivesSAXReader(primitivesReader);
    }

    public SAXSource toSAXSource() {
        return new SAXSource(this.getXMLReader(), this.inputSource);
    }
}

