/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text.alphabet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.Collator;
import java.text.RuleBasedCollator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.mapeadores.util.exceptions.InternalResourceException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.text.alphabet.AlphabeticEntry;
import net.mapeadores.util.text.collation.CollationUnit;

public final class Alphabet
implements AlphabeticEntry {
    private static final Lang DEFAULT_LANG = Lang.build("en");
    private static final Map<Lang, InitialInfo> initialInfoMap = new HashMap<Lang, InitialInfo>();
    private static final Map<Lang, Article[]> articleArrayMap = new HashMap<Lang, Article[]>();
    private static final Set<Lang> nulLangIntegerSet = new HashSet<Lang>();
    private final String sourceString;
    private final String articleString;
    private final String entryString;
    private final String initialChar;
    private final String alphabeticSort;
    private final boolean withSeparationSpace;

    private Alphabet(String sourceString, String articleString, String entryString, String initialChar, String alphabeticSort, boolean withSeparationSpace) {
        this.sourceString = sourceString;
        this.articleString = articleString;
        this.entryString = entryString;
        this.initialChar = initialChar;
        this.alphabeticSort = alphabeticSort;
        this.withSeparationSpace = withSeparationSpace;
    }

    public static AlphabeticEntry newInstance(String sourceString, Lang lang) {
        return Alphabet.newInstance(sourceString, lang, lang);
    }

    public static AlphabeticEntry newInstance(String sourceString, Lang articleLang, Lang sortLang) {
        String articleString = null;
        boolean withEspace = false;
        String entryString = sourceString;
        Article[] array = Alphabet.getArray(articleLang);
        if (array != null) {
            for (Article currentArticle : array) {
                if (!sourceString.startsWith(currentArticle.getArticleString())) continue;
                int length = currentArticle.getArticleLength();
                if (sourceString.length() <= length) break;
                articleString = currentArticle.getTrimedArticleString();
                withEspace = currentArticle.isWithEspace();
                entryString = sourceString.substring(length);
                break;
            }
        }
        InitialInfo initialInfo = Alphabet.getInitialInfo(sortLang);
        String alphabeticSort = initialInfo.getAlphabeticSort(entryString);
        String initialChar = initialInfo.getInitial(alphabeticSort);
        return new Alphabet(sourceString, articleString, entryString, initialChar, alphabeticSort, withEspace);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Article[] getArray(Lang lang) {
        if (lang == null) {
            return null;
        }
        if (nulLangIntegerSet.contains(lang)) {
            return null;
        }
        Article[] obj = articleArrayMap.get(lang);
        if (obj == null) {
            obj = Alphabet.initArray(lang);
            if (obj == null && !lang.isRootLang()) {
                obj = Alphabet.getArray(lang.getRootLang());
            }
            if (obj == null) {
                Set<Lang> set = nulLangIntegerSet;
                synchronized (set) {
                    nulLangIntegerSet.add(lang);
                }
            }
            Map<Lang, Article[]> map = articleArrayMap;
            synchronized (map) {
                articleArrayMap.put(lang, obj);
            }
        }
        return obj;
    }

    private static Article[] initArray(Lang lang) {
        Article[] articleArray;
        InputStream inputStream = Alphabet.class.getResourceAsStream("resources/article_" + lang.toString() + ".txt");
        if (inputStream == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
        try {
            String ligne;
            ArrayList<String> list = new ArrayList<String>();
            while ((ligne = reader.readLine()) != null) {
                if ((ligne = ligne.trim()).length() <= 0 || ligne.charAt(0) == '#') continue;
                ligne = ligne.replace('_', ' ');
                list.add(ligne);
            }
            int size = list.size();
            Article[] result = new Article[size];
            for (int i = 0; i < size; ++i) {
                result[i] = new Article((String)list.get(i));
            }
            articleArray = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ioe) {
                throw new InternalResourceException(ioe);
            }
        }
        reader.close();
        return articleArray;
    }

    @Override
    public boolean isWithArticle() {
        return !this.sourceString.equals(this.entryString);
    }

    @Override
    public String getSourceString() {
        return this.sourceString;
    }

    @Override
    public String getArticleString() {
        return this.articleString;
    }

    @Override
    public String getEntryString() {
        return this.entryString;
    }

    @Override
    public boolean isWithSeparationSpace() {
        return this.withSeparationSpace;
    }

    @Override
    public String getInitialChar() {
        return this.initialChar;
    }

    @Override
    public String getAlphabeticSort() {
        return this.alphabeticSort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static InitialInfo getInitialInfo(Lang lang) {
        if (lang == null) {
            return Alphabet.getInitialInfo(DEFAULT_LANG);
        }
        InitialInfo initialInfo = initialInfoMap.get(lang);
        if (initialInfo == null) {
            Map<Lang, InitialInfo> map = initialInfoMap;
            synchronized (map) {
                RuleBasedCollator collator = (RuleBasedCollator)Collator.getInstance(lang.toLocale());
                collator.setStrength(0);
                initialInfo = new InitialInfo(collator);
                initialInfoMap.put(lang, initialInfo);
            }
        }
        return initialInfo;
    }

    private static class Article {
        private final String articleString;
        private final boolean withEspace;
        private final String trimedArticleString;

        Article(String articleString) {
            this.articleString = articleString;
            if (articleString.charAt(articleString.length() - 1) == ' ') {
                this.trimedArticleString = articleString.substring(0, articleString.length() - 1);
                this.withEspace = true;
            } else {
                this.withEspace = false;
                this.trimedArticleString = articleString;
            }
        }

        public String getArticleString() {
            return this.articleString;
        }

        public boolean isWithEspace() {
            return this.withEspace;
        }

        public String getTrimedArticleString() {
            return this.trimedArticleString;
        }

        public int getArticleLength() {
            return this.articleString.length();
        }
    }

    private static class InitialInfo {
        private final RuleBasedCollator collator;
        private final Map<Character, String> initialStringMap = new HashMap<Character, String>();

        private InitialInfo(RuleBasedCollator collator) {
            char c;
            this.collator = collator;
            for (c = '0'; c <= '9'; c = (char)(c + '\u0001')) {
                this.addInitialString(c);
            }
            for (c = 'A'; c <= 'Z'; c = (char)(c + '\u0001')) {
                this.addInitialString(c);
            }
        }

        private void addInitialString(char c) {
            char[] array = new char[]{c};
            String initialString = new String(array);
            String collatedKey = CollationUnit.collate(initialString, this.collator, true);
            this.initialStringMap.put(Character.valueOf(collatedKey.charAt(0)), initialString);
        }

        private String getAlphabeticSort(String entryString) {
            String cleanedEntry = StringUtils.reduceToLetterAndDigit(entryString);
            return CollationUnit.collate(cleanedEntry, this.collator, true);
        }

        private String getInitial(String alphabeticSort) {
            if (alphabeticSort.length() == 0) {
                return null;
            }
            Character initial = Character.valueOf(alphabeticSort.charAt(0));
            String result = this.initialStringMap.get(initial);
            if (result == null) {
                return "_";
            }
            return result;
        }
    }
}

