/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.io.UnsupportedEncodingException;
import net.mapeadores.util.text.UTF8BridgeException;

public class UTF8Bridge {
    private static final short UTF8 = 11;
    private static final short ISO_8859_1 = 12;
    private static final short OTHER = 13;
    short type = (short)13;
    String charsetName;

    public UTF8Bridge(String charsetName) {
        if (charsetName != null) {
            this.charsetName = charsetName;
            if (charsetName.equals("UTF-8")) {
                this.type = (short)11;
            } else if (charsetName.equals("ISO-8859-1")) {
                this.type = (short)12;
            }
        } else {
            this.type = (short)12;
            this.charsetName = "ISO-8859-1";
        }
    }

    public String toUTF8(String s) {
        if (this.type == 11) {
            return s;
        }
        if (s == null) {
            return null;
        }
        try {
            return new String(s.getBytes(this.charsetName), "UTF-8");
        }
        catch (UnsupportedEncodingException uue) {
            throw new UTF8BridgeException(this.charsetName, uue);
        }
    }

    public String getCharsetName() {
        return this.charsetName;
    }
}

