/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

import java.util.LinkedHashMap;
import java.util.Map;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.Phrase;

public class PhraseCache {
    private final Map<Lang, Label> labelMap = new LinkedHashMap<Lang, Label>();
    private final String name;
    private Phrase cachedPhrase;

    public PhraseCache(String name) {
        this.name = name;
    }

    public synchronized void clear() {
        this.labelMap.clear();
        this.cachedPhrase = null;
    }

    public synchronized void putLabels(Labels labels) {
        for (Label label : labels) {
            this.labelMap.put(label.getLang(), label);
        }
        this.cachedPhrase = null;
    }

    public synchronized boolean putLabel(Label label) {
        Lang lang = label.getLang();
        Label current = this.labelMap.get(lang);
        if (current != null && LabelUtils.areEquals(current, label)) {
            return false;
        }
        this.labelMap.put(lang, label);
        this.cachedPhrase = null;
        return true;
    }

    public synchronized boolean removeLabel(Lang lang) {
        Label label = this.labelMap.remove(lang);
        if (label != null) {
            this.cachedPhrase = null;
            return true;
        }
        return false;
    }

    public Phrase getPhrase() {
        Phrase result = this.cachedPhrase;
        if (result == null) {
            result = this.cache();
        }
        return result;
    }

    public boolean isEmpty() {
        return this.labelMap.isEmpty();
    }

    private synchronized Phrase cache() {
        Phrase cache;
        this.cachedPhrase = cache = LabelUtils.toPhrase(this.name, this.labelMap);
        return cache;
    }
}

