/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.text;

public final class OneDistance {
    private OneDistance() {
    }

    public static boolean apply(String left, String right) {
        int rightLength;
        int leftLength = left.length();
        if (leftLength > (rightLength = right.length())) {
            return OneDistance.apply(right, left);
        }
        int diff = rightLength - leftLength;
        switch (diff) {
            case 0: {
                return OneDistance.substitution(left, right);
            }
            case 1: {
                return OneDistance.remove(left, right);
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean remove(String left, String right) {
        boolean oneChance = true;
        boolean result = true;
        int leftLength = left.length();
        int rightIndex = 0;
        int i = 0;
        while (i < leftLength) {
            char rightChar;
            char leftChar = left.charAt(i);
            if (leftChar != (rightChar = right.charAt(rightIndex))) {
                if (!oneChance) return false;
                if (leftChar != (rightChar = right.charAt(++rightIndex))) return false;
                oneChance = false;
            }
            ++rightIndex;
            ++i;
        }
        return result;
    }

    private static boolean substitution(String left, String right) {
        boolean oneChance = true;
        boolean result = true;
        int length = left.length();
        for (int i = 0; i < length; ++i) {
            char rightChar;
            char leftChar = left.charAt(i);
            if (leftChar == (rightChar = right.charAt(i))) continue;
            if (oneChance) {
                if (i < length - 1) {
                    char nextLeftChar = left.charAt(i + 1);
                    char nextRightChar = right.charAt(i + 1);
                    if (nextLeftChar == rightChar && nextRightChar == leftChar) {
                        ++i;
                    }
                }
                oneChance = false;
                continue;
            }
            result = false;
            break;
        }
        return result;
    }
}

