/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.servlets.handlers;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import net.mapeadores.util.servlets.ResponseHandler;

public class SimpleResponseHandler
implements ResponseHandler {
    private final String text;
    private final String contentType;
    private long lastModified = -1L;
    private String charset = "UTF-8";

    public SimpleResponseHandler(String text) {
        this.text = text;
        this.contentType = "text/plain";
    }

    public SimpleResponseHandler(String text, String contentType) {
        this.text = text;
        this.contentType = contentType;
    }

    @Override
    public long getLastModified() {
        return this.lastModified;
    }

    public SimpleResponseHandler lastModified(long lastModified) {
        this.lastModified = lastModified;
        return this;
    }

    public SimpleResponseHandler charset(String charset) {
        this.charset = charset;
        return this;
    }

    @Override
    public void handleResponse(HttpServletResponse response) throws IOException {
        response.setContentType(this.contentType + ";charset=" + this.charset);
        try (PrintWriter pw = response.getWriter();){
            pw.print(this.text);
        }
    }

    public static SimpleResponseHandler init(String text) {
        return new SimpleResponseHandler(text);
    }

    public static SimpleResponseHandler init(String text, String contentType) {
        return new SimpleResponseHandler(text);
    }
}

