/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.request;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.RandomAccess;
import java.util.Set;
import net.mapeadores.util.attr.AttributeUtils;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreferenceBuilder;
import net.mapeadores.util.request.AppendableRequestMap;
import net.mapeadores.util.request.FileValue;
import net.mapeadores.util.request.OutputInfo;
import net.mapeadores.util.request.RequestConf;
import net.mapeadores.util.request.RequestConfBuilder;
import net.mapeadores.util.request.RequestMap;
import net.mapeadores.util.request.SupplementaryParameter;
import net.mapeadores.util.request.xml.RequestConfDOMReader;
import net.mapeadores.util.xml.DOMUtils;
import org.w3c.dom.Document;

public final class RequestUtils {
    public static final List<SupplementaryParameter> EMPTY_SUPPLEMENTARYPARAMETERLIST = Collections.emptyList();
    public static final RequestConf EMPTY_REQUESTCONF = new EmptyRequestConf();

    private RequestUtils() {
    }

    public static AppendableRequestMap merge(RequestMap requestMap, List<SupplementaryParameter> supplementaryParameterList) {
        AppendableRequestMap appendableRequestMap = new AppendableRequestMap(requestMap);
        appendableRequestMap.addSupplementaryParameters(supplementaryParameterList);
        return appendableRequestMap;
    }

    public static RequestConf parseRequestConf(File f) throws IOException {
        Document document = DOMUtils.readDocument(f);
        return RequestUtils.parseRequestConf(document);
    }

    public static RequestConf parseRequestConf(Document document) {
        RequestConfBuilder requestConfBuilder = new RequestConfBuilder();
        RequestConfDOMReader reader = new RequestConfDOMReader(requestConfBuilder);
        reader.readConf(document.getDocumentElement());
        return requestConfBuilder.toRequestConf();
    }

    public static short getJsonType(RequestMap requestMap) {
        String jsonType = requestMap.getParameter("jsontype");
        if (jsonType == null) {
            if (requestMap.getParameter("callback") != null) {
                return 2;
            }
            return 1;
        }
        switch (jsonType) {
            case "jsonp": {
                return 2;
            }
            case "jsonh": {
                return 3;
            }
        }
        return 1;
    }

    public static boolean isJsonDefined(RequestMap requestMap) {
        OutputInfo outputInfo = OutputInfo.buildFromRequest(requestMap);
        return outputInfo.getType() == 2;
    }

    public static String jsonTypeToContentType(short jsonType) {
        switch (jsonType) {
            case 1: {
                return "application/json";
            }
            case 3: {
                return "text/html;charset=UTF-8";
            }
            case 2: {
                return "application/javascript;charset=UTF-8";
            }
        }
        throw new IllegalArgumentException("Unknown type: " + jsonType);
    }

    public static Lang getDefaultLang(RequestMap requestMap) {
        return RequestUtils.checkLangPreference(requestMap, new LangPreferenceBuilder()).addLang(Lang.build("en")).toLangPreference().getFirstLang();
    }

    public static LangPreferenceBuilder checkLangPreference(RequestMap requestMap, LangPreferenceBuilder langPreferenceBuilder) {
        Locale[] acceptableLocaleArray;
        String localeParameter = requestMap.getParameter("locale");
        if (localeParameter != null) {
            try {
                Lang lang = Lang.parse(localeParameter);
                langPreferenceBuilder.addLang(lang);
            }
            catch (ParseException lang) {
                // empty catch block
            }
        }
        if ((acceptableLocaleArray = requestMap.getAcceptableLocaleArray()) != null) {
            int length = acceptableLocaleArray.length;
            for (int i = 0; i < length; ++i) {
                try {
                    Lang lang = Lang.fromLocale(acceptableLocaleArray[i]);
                    langPreferenceBuilder.addLang(lang);
                    continue;
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return langPreferenceBuilder;
    }

    public static List<SupplementaryParameter> wrap(SupplementaryParameter[] array) {
        return new SupplementaryParameterList(array);
    }

    public static RequestMap reduceToSuffix(RequestMap requestMap, String suffix) {
        if (suffix == null || suffix.isEmpty()) {
            return requestMap;
        }
        return new SuffixRequestMap(requestMap, suffix);
    }

    private static class SupplementaryParameterList
    extends AbstractList<SupplementaryParameter>
    implements RandomAccess {
        private final SupplementaryParameter[] array;

        private SupplementaryParameterList(SupplementaryParameter[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SupplementaryParameter get(int index) {
            return this.array[index];
        }
    }

    private static class SuffixRequestMap
    implements RequestMap {
        private final RequestMap requestMap;
        private final String suffix;
        private final Set<String> paramNameSet;

        private SuffixRequestMap(RequestMap requestMap, String suffix) {
            this.requestMap = requestMap;
            this.suffix = suffix;
            int suffixLength = suffix.length();
            HashSet<String> set = new HashSet<String>();
            for (String paramName : requestMap.getParameterNameSet()) {
                if (!paramName.startsWith(suffix)) continue;
                set.add(paramName.substring(suffixLength));
            }
            this.paramNameSet = Collections.unmodifiableSet(set);
        }

        @Override
        public FileValue getFileValue(String name) {
            return this.requestMap.getFileValue(this.suffix + name);
        }

        @Override
        public FileValue[] getFileValues(String name) {
            return this.requestMap.getFileValues(this.suffix + name);
        }

        @Override
        public String getParameter(String name) {
            return this.requestMap.getParameter(this.suffix + name);
        }

        @Override
        public String[] getParameterValues(String name) {
            return this.requestMap.getParameterValues(this.suffix + name);
        }

        @Override
        public Set<String> getParameterNameSet() {
            return this.paramNameSet;
        }

        @Override
        public Locale[] getAcceptableLocaleArray() {
            return this.requestMap.getAcceptableLocaleArray();
        }

        @Override
        public Object getSourceObject() {
            return this.requestMap.getSourceObject();
        }
    }

    private static class EmptyRequestConf
    implements RequestConf {
        private EmptyRequestConf() {
        }

        @Override
        public List<SupplementaryParameter> getSupplementaryParameterList() {
            return EMPTY_SUPPLEMENTARYPARAMETERLIST;
        }

        @Override
        public Attributes getAttributes() {
            return AttributeUtils.EMPTY_ATTRIBUTES;
        }
    }
}

