/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;

public class TimeLog {
    private static final SimpleDateFormat ISO_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss,SSS'Z'");
    private static final String SEPARATOR = "\t";
    private final long startTime;
    private final StringBuilder internalBuffer = new StringBuilder();
    private PrintWriter pw;
    private long previousTime;
    private String currentAction = null;
    private boolean empty = true;

    public TimeLog(String logName) {
        this.print(logName);
        this.print(SEPARATOR);
        this.print(SEPARATOR);
        this.print("00:00");
        this.print(SEPARATOR);
        this.startTime = System.currentTimeMillis();
        this.print(ISO_FORMAT.format(new Date(this.startTime)));
        this.previousTime = this.startTime;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public void setPrintWriter(PrintWriter pw) {
        if (pw != null) {
            pw.print(this.internalBuffer.toString());
            pw.flush();
        }
        this.pw = pw;
    }

    public TimeLog logAction(String actionKey) {
        this.flushAction();
        this.print("\n");
        this.print(actionKey);
        this.empty = false;
        this.currentAction = actionKey;
        this.flush();
        return this;
    }

    public TimeLog log(Exception e) {
        this.empty = false;
        return this.logStep("exception@" + e.getLocalizedMessage());
    }

    public TimeLog logStep(String name) {
        this.flushAction();
        long currentTime = System.currentTimeMillis();
        this.print("\n");
        this.print(name);
        this.print(SEPARATOR);
        this.print(SEPARATOR);
        this.printIntervalle(currentTime, this.startTime);
        this.print(SEPARATOR);
        this.print(ISO_FORMAT.format(new Date(currentTime)));
        this.flush();
        return this;
    }

    public String toString() {
        return this.internalBuffer.toString();
    }

    private void flushAction() {
        if (this.currentAction != null) {
            long currentTime = System.currentTimeMillis();
            this.print(SEPARATOR);
            this.printIntervalle(currentTime, this.previousTime);
            this.print(SEPARATOR);
            this.printIntervalle(currentTime, this.startTime);
            this.previousTime = currentTime;
            this.currentAction = null;
            this.flush();
        }
    }

    private void print(String text) {
        this.internalBuffer.append(text);
        if (this.pw != null) {
            this.pw.print(text);
            this.pw.flush();
        }
    }

    private void flush() {
        if (this.pw != null) {
            this.pw.flush();
        }
    }

    public static String toExceptionLogString(String name, Exception e) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter buf = new PrintWriter(stringWriter);
        stringWriter.append(name);
        stringWriter.append(SEPARATOR);
        buf.append(ISO_FORMAT.format(new Date(System.currentTimeMillis())));
        buf.append("\n\n");
        e.printStackTrace(buf);
        return stringWriter.toString();
    }

    private void printIntervalle(long currentTime, long oldTime) {
        int diff = (int)(currentTime - oldTime);
        if (diff == 0) {
            this.print("00:00");
        } else {
            double ms = (double)diff / 1000.0;
            double s = Math.floor(ms);
            ms = (ms - s) * 1000.0;
            if (s > 0.0) {
                double mn = Math.floor(s / 60.0);
                s -= mn * 60.0;
                if (mn < 10.0) {
                    this.print("0");
                }
                this.print(String.valueOf((int)mn));
            } else {
                this.print("00");
            }
            this.print(":");
            if (s < 10.0) {
                this.print("0");
            }
            this.print(String.valueOf((int)s));
            if (ms > 0.0) {
                this.print(",");
                if (ms < 10.0) {
                    this.print("0");
                }
                if (ms < 100.0) {
                    this.print("0");
                }
                this.print(String.valueOf((int)ms));
            }
        }
    }

    static {
        ISO_FORMAT.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }
}

