/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.util.ArrayList;
import java.util.List;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.logging.MessageSource;

public class MessageSourceBuilder
implements MessageHandler {
    private final String name;
    private final List<InternalMessageSourceEntry> entryList = new ArrayList<InternalMessageSourceEntry>();

    public MessageSourceBuilder(String name) {
        this.name = name;
    }

    public boolean isEmpty() {
        return this.entryList.isEmpty();
    }

    @Override
    public void addMessage(String category, Message message) {
        if (category == null) {
            throw new IllegalArgumentException("category is null");
        }
        if (message == null) {
            throw new IllegalArgumentException("message is null");
        }
        this.entryList.add(new InternalMessageSourceEntry(category, message));
    }

    public List<MessageSource.Entry> toEntryList() {
        return LogUtils.wrap(this.entryList.toArray(new MessageSource.Entry[this.entryList.size()]));
    }

    public List<Message> toMessageList(String category) {
        ArrayList<Message> list = new ArrayList<Message>();
        for (InternalMessageSourceEntry entry : this.entryList) {
            if (!entry.getCategory().startsWith(category)) continue;
            list.add(entry.getMessage());
        }
        return list;
    }

    public MessageSource toMessageSource() {
        List<MessageSource.Entry> finalList = LogUtils.wrap(this.entryList.toArray(new MessageSource.Entry[this.entryList.size()]));
        return new InternalMessageSource(this.name, finalList);
    }

    private static class InternalMessageSourceEntry
    implements MessageSource.Entry {
        private final String category;
        private final Message message;

        private InternalMessageSourceEntry(String category, Message message) {
            this.category = category;
            this.message = message;
        }

        @Override
        public String getCategory() {
            return this.category;
        }

        @Override
        public Message getMessage() {
            return this.message;
        }
    }

    private static class InternalMessageSource
    implements MessageSource {
        private final String name;
        private final List<MessageSource.Entry> messageList;

        private InternalMessageSource(String name, List<MessageSource.Entry> messageList) {
            this.name = name;
            this.messageList = messageList;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public List<MessageSource.Entry> getEntryList() {
            return this.messageList;
        }
    }
}

