/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageLog;
import net.mapeadores.util.logging.MessageSource;
import net.mapeadores.util.logging.MessageSourceBuilder;
import net.mapeadores.util.logging.MultiMessageHandler;

public class MessageLogBuilder
implements MultiMessageHandler {
    private final Map<String, MessageSourceBuilder> builderMap = new LinkedHashMap<String, MessageSourceBuilder>();
    private MessageSourceBuilder currentBuffer = null;

    @Override
    public void setCurrentSource(String sourceName) {
        MessageSourceBuilder builder = this.builderMap.get(sourceName);
        if (builder == null) {
            builder = new MessageSourceBuilder(sourceName);
            this.builderMap.put(sourceName, builder);
        }
        this.currentBuffer = builder;
    }

    @Override
    public void addMessage(String category, Message message) {
        if (this.currentBuffer == null) {
            this.setCurrentSource("");
        }
        this.currentBuffer.addMessage(category, message);
    }

    public MessageLog toMessageLog() {
        ArrayList<MessageSource> tempList = new ArrayList<MessageSource>();
        for (MessageSourceBuilder builder : this.builderMap.values()) {
            MessageSource messageSource = builder.toMessageSource();
            if (messageSource.isEmpty()) continue;
            tempList.add(messageSource);
        }
        List<MessageSource> finalList = LogUtils.wrap(tempList.toArray(new MessageSource[tempList.size()]));
        return new InternalMessageLog(finalList);
    }

    private static class InternalMessageLog
    implements MessageLog {
        private final List<MessageSource> list;

        private InternalMessageLog(List<MessageSource> list) {
            this.list = list;
        }

        @Override
        public List<MessageSource> getMessageSourceList() {
            return this.list;
        }
    }
}

