/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.logging;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.RandomAccess;
import net.mapeadores.util.logging.LineMessageHandler;
import net.mapeadores.util.logging.MessageByLine;
import net.mapeadores.util.logging.MessageByLineLog;
import net.mapeadores.util.logging.SimpleLineMessageHandler;

public class MessageByLineLogBuilder {
    private final Map<String, SimpleLineMessageHandler> handlerMap = new LinkedHashMap<String, SimpleLineMessageHandler>();

    public LineMessageHandler setCurrentURI(String uri) {
        SimpleLineMessageHandler handler = this.handlerMap.get(uri);
        if (handler == null) {
            handler = new SimpleLineMessageHandler();
            this.handlerMap.put(uri, handler);
        }
        return handler;
    }

    public MessageByLineLog toMessageByLineLog() {
        ArrayList<InternalLogGroup> logGroupList = new ArrayList<InternalLogGroup>();
        for (Map.Entry<String, SimpleLineMessageHandler> entry : this.handlerMap.entrySet()) {
            SimpleLineMessageHandler handler = entry.getValue();
            if (!handler.hasMessage()) continue;
            logGroupList.add(new InternalLogGroup(entry.getKey(), handler.toMessageByLineList()));
        }
        MessageByLineLog.LogGroup[] array = logGroupList.toArray(new MessageByLineLog.LogGroup[logGroupList.size()]);
        return new InternalMessageByLineLog(new MessageByLineLogGroupList(array));
    }

    private static class InternalLogGroup
    implements MessageByLineLog.LogGroup {
        private final String uri;
        private final List<MessageByLine> list;

        private InternalLogGroup(String uri, List<MessageByLine> list) {
            this.uri = uri;
            this.list = list;
        }

        @Override
        public String getURI() {
            return this.uri;
        }

        @Override
        public List<MessageByLine> getMessageByLineList() {
            return this.list;
        }
    }

    private static class InternalMessageByLineLog
    implements MessageByLineLog {
        private final List<MessageByLineLog.LogGroup> list;

        private InternalMessageByLineLog(List<MessageByLineLog.LogGroup> list) {
            this.list = list;
        }

        @Override
        public List<MessageByLineLog.LogGroup> getLogGroupList() {
            return this.list;
        }
    }

    private static class MessageByLineLogGroupList
    extends AbstractList<MessageByLineLog.LogGroup>
    implements RandomAccess {
        private final MessageByLineLog.LogGroup[] array;

        private MessageByLineLogGroupList(MessageByLineLog.LogGroup[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public MessageByLineLog.LogGroup get(int index) {
            return this.array[index];
        }
    }
}

