/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.text.ParseException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import net.mapeadores.util.conditions.ConditionsUtils;
import net.mapeadores.util.conditions.TextCondition;
import net.mapeadores.util.conditions.TextTestEngine;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.CodeCatalog;
import net.mapeadores.util.localisation.Country;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangPreference;
import net.mapeadores.util.localisation.LangScript;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.text.StringUtils;

public class MessageLocalisationFactory
implements CodeCatalog {
    private static final Lang NO_LINGUISTIC = Lang.build("zxx");
    private static final Lang ENGLISH = Lang.build("en");
    private static final Lang FRENCH = Lang.build("fr");
    private static final Pattern langCodePattern;
    private static final Pattern countryCodePattern;
    private final Map<String, MessageInfo> infoMap = new HashMap<String, MessageInfo>();
    private final SortedMap<String, MessageInfo> langMap = new TreeMap<String, MessageInfo>();
    private final SortedMap<String, MessageInfo> countryMap = new TreeMap<String, MessageInfo>();
    private final Set<String> unmodifiableLangSet = Collections.unmodifiableSet(this.langMap.keySet());
    private final Set<String> unmodifiableCountrySet = Collections.unmodifiableSet(this.countryMap.keySet());

    public MessageLocalisation newInstance(Lang lang) {
        Lang[] langArray = new Lang[]{lang};
        return new InternalMessageLocalisation(langArray, lang.toLocale());
    }

    public MessageLocalisation newInstance(LangPreference langPreference, Locale formatLocale) {
        int langLength = langPreference.size();
        Lang[] langArray = new Lang[langLength];
        for (int i = 0; i < langLength; ++i) {
            langArray[i] = (Lang)langPreference.get(i);
        }
        return new InternalMessageLocalisation(langArray, formatLocale);
    }

    protected void addEntry(String key, Lang lang, String text) {
        MessageInfo messageInfo = this.infoMap.get(key);
        if (messageInfo == null) {
            messageInfo = new MessageInfo(key, text);
            this.infoMap.put(key, messageInfo);
            if (langCodePattern.matcher(key).matches()) {
                this.langMap.put(key, messageInfo);
            } else if (countryCodePattern.matcher(key).matches()) {
                this.countryMap.put(key, messageInfo);
            }
        }
        messageInfo.add(lang, text);
    }

    @Override
    public Set<String> getLangCodeSet() {
        return this.unmodifiableLangSet;
    }

    @Override
    public Set<String> getCountryCodeSet() {
        return this.unmodifiableCountrySet;
    }

    @Override
    public Set<String> getLangCodeSet(TextCondition condition, LangPreference langPreference) {
        switch (ConditionsUtils.getConditionType(condition)) {
            case 5: 
            case 6: {
                return MessageLocalisationFactory.getPartialCodeSet(this.langMap.values(), condition, langPreference);
            }
            case 2: 
            case 3: {
                return Collections.emptySet();
            }
        }
        return this.unmodifiableLangSet;
    }

    @Override
    public Set<String> getCountryCodeSet(TextCondition condition, LangPreference langPreference) {
        switch (ConditionsUtils.getConditionType(condition)) {
            case 5: 
            case 6: {
                return MessageLocalisationFactory.getPartialCodeSet(this.countryMap.values(), condition, langPreference);
            }
            case 2: {
                return Collections.emptySet();
            }
        }
        return this.unmodifiableCountrySet;
    }

    private static Set<String> getPartialCodeSet(Collection<MessageInfo> collection, TextCondition condition, LangPreference langPreference) {
        TextTestEngine[] engineArray = MessageLocalisationFactory.initEngineArray(condition, langPreference);
        TreeSet<String> result = new TreeSet<String>();
        for (MessageInfo messageInfo : collection) {
            if (!messageInfo.test(engineArray)) continue;
            result.add(messageInfo.key);
        }
        return result;
    }

    private static TextTestEngine[] initEngineArray(TextCondition condition, LangPreference langPreference) {
        int langLength = langPreference.size();
        TextTestEngine[] engineArray = new TextTestEngine[langLength];
        for (int i = 0; i < langLength; ++i) {
            Lang lang = (Lang)langPreference.get(i);
            engineArray[i] = TextTestEngine.newInstance(condition, lang);
        }
        return engineArray;
    }

    static {
        try {
            langCodePattern = Pattern.compile("^[a-z][a-z][a-z]?$");
            countryCodePattern = Pattern.compile("^[A-Z][A-Z]$");
        }
        catch (PatternSyntaxException pse) {
            throw new ShouldNotOccurException(pse);
        }
    }

    private class InternalMessageLocalisation
    implements MessageLocalisation {
        private final Lang[] langArray;
        private final Locale formatLocale;

        private InternalMessageLocalisation(Lang[] langArray, Locale formatLocale) {
            this.langArray = langArray;
            this.formatLocale = formatLocale;
        }

        @Override
        public String toString(String messageKey) {
            if (messageKey.isEmpty()) {
                return "";
            }
            MessageInfo messageInfo = (MessageInfo)MessageLocalisationFactory.this.infoMap.get(messageKey);
            if (messageInfo == null) {
                return this.testCode(messageKey);
            }
            return messageInfo.getText(this.langArray);
        }

        @Override
        public String toString(Message message) {
            String messageKey = message.getMessageKey();
            if (messageKey.isEmpty()) {
                return LocalisationUtils.joinValues(message);
            }
            MessageInfo messageInfo = (MessageInfo)MessageLocalisationFactory.this.infoMap.get(messageKey);
            if (messageInfo == null) {
                return this.testCode(messageKey);
            }
            String text = messageInfo.getText(this.langArray);
            if (text == null) {
                return null;
            }
            try {
                return StringUtils.formatMessage(text, message.getMessageValues(), this.formatLocale);
            }
            catch (StringUtils.FormatException fe) {
                return "[" + messageKey + "] " + fe.getMessage();
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private String testCode(String messageKey) {
            try {
                Country region;
                String langTitle;
                Lang lang = Lang.parse(messageKey);
                if (lang.isRootLang()) return null;
                StringBuilder buf = new StringBuilder();
                LangScript langScript = lang.getScript();
                if (langScript != null) {
                    langTitle = this.toString(lang.getRootLang().toString() + "-" + langScript.toString());
                    if (langTitle != null) {
                        buf.append(StringUtils.getFirstPart(langTitle));
                    } else {
                        langTitle = this.toString(lang.getRootLang().toString());
                        if (langTitle == null) return null;
                        buf.append(StringUtils.getFirstPart(langTitle));
                        buf.append(" (");
                        String scriptTitle = this.toString(langScript.toString());
                        if (scriptTitle != null) {
                            buf.append(StringUtils.getFirstPart(scriptTitle));
                        } else {
                            buf.append(langScript.toString());
                        }
                        buf.append(")");
                    }
                } else {
                    langTitle = this.toString(lang.getRootLang().toString());
                    if (langTitle == null) return null;
                    buf.append(StringUtils.getFirstPart(langTitle));
                }
                int variantCount = lang.getVariantCount();
                if (variantCount > 0) {
                    buf.append(" (");
                    for (int i = 0; i < variantCount; ++i) {
                        if (i > 0) {
                            buf.append('-');
                        }
                        buf.append(lang.getVariant(i));
                    }
                    buf.append(")");
                }
                if ((region = lang.getRegion()) == null) return buf.toString();
                buf.append(" (");
                String regionTitle = this.toString(region.toString());
                if (regionTitle != null) {
                    buf.append(StringUtils.getFirstPart(regionTitle));
                } else {
                    buf.append(region.toString());
                }
                buf.append(")");
                return buf.toString();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return null;
        }

        @Override
        public boolean containsKey(String messageKey) {
            if (MessageLocalisationFactory.this.infoMap.containsKey(messageKey)) {
                return true;
            }
            try {
                Lang lang = Lang.parse(messageKey);
                return MessageLocalisationFactory.this.infoMap.containsKey(lang.getRootLang().toString());
            }
            catch (ParseException pe) {
                return false;
            }
        }
    }

    private class MessageInfo {
        private final String key;
        private final Map<Lang, String> textMap = new HashMap<Lang, String>();
        private final String defaultText;

        private MessageInfo(String key, String defaultText) {
            this.key = key;
            this.defaultText = defaultText;
        }

        private void add(Lang lang, String text) {
            if (!this.textMap.containsKey(lang)) {
                this.textMap.put(lang, text);
            }
        }

        private String getText(Lang[] langArray) {
            String text;
            for (Lang lang : langArray) {
                if (lang.equals(NO_LINGUISTIC)) {
                    return this.key;
                }
                text = this.getText(lang);
                if (text == null) continue;
                return text;
            }
            text = this.getText(ENGLISH);
            if (text != null) {
                return text;
            }
            text = this.getText(FRENCH);
            if (text != null) {
                return text;
            }
            return this.defaultText;
        }

        private String getText(Lang lang) {
            String text = this.textMap.get(lang);
            if (text != null) {
                return text;
            }
            if (!lang.isRootLang() && (text = this.textMap.get(lang.getRootLang())) != null) {
                return text;
            }
            return null;
        }

        private boolean test(TextTestEngine[] engineArray) {
            for (TextTestEngine engine : engineArray) {
                String[] tokens;
                Lang lang = engine.getLang();
                String text = this.textMap.get(lang);
                if (text == null) continue;
                for (String token : tokens = StringUtils.getTokens(text, ';', (short)2)) {
                    if (!engine.isSelected(token)) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

