/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.localisation;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.localisation.MessageLocalisation;
import net.mapeadores.util.text.StringUtils;

public class BundleMessageLocalisation
implements MessageLocalisation {
    private static final ConcurrentMap<CacheKey, BundleMessageLocalisation> localisationMap = new ConcurrentHashMap<CacheKey, BundleMessageLocalisation>();
    private final ResourceBundle resourceBundle;

    private BundleMessageLocalisation(ResourceBundle resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    @Override
    public String toString(String messageKey) {
        if (messageKey.isEmpty()) {
            return "";
        }
        try {
            messageKey = LocalisationUtils.cleanMessageKey(messageKey);
            return this.resourceBundle.getString(messageKey);
        }
        catch (MissingResourceException mre) {
            return null;
        }
    }

    @Override
    public String toString(Message message) {
        String messageKey = message.getMessageKey();
        if (messageKey.isEmpty()) {
            return LocalisationUtils.joinValues(message);
        }
        try {
            String messageString = this.resourceBundle.getString(LocalisationUtils.cleanMessageKey(messageKey));
            return StringUtils.formatMessage(messageString, message.getMessageValues(), this.resourceBundle.getLocale());
        }
        catch (MissingResourceException mre) {
            return null;
        }
        catch (StringUtils.FormatException fe) {
            return "[" + messageKey + "] " + fe.getMessage();
        }
    }

    @Override
    public boolean containsKey(String messageKey) {
        try {
            messageKey = LocalisationUtils.cleanMessageKey(messageKey);
            this.resourceBundle.getString(messageKey);
            return true;
        }
        catch (MissingResourceException mre) {
            return false;
        }
    }

    public ResourceBundle getResourceBundle() {
        return this.resourceBundle;
    }

    public static BundleMessageLocalisation getInstance(String baseName, Locale locale, ClassLoader classLoader) {
        CacheKey cacheKey = new CacheKey(baseName, locale);
        BundleMessageLocalisation messageLocalisation = (BundleMessageLocalisation)localisationMap.get(cacheKey);
        if (messageLocalisation == null) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle(baseName, locale, classLoader);
            messageLocalisation = new BundleMessageLocalisation(resourceBundle);
            localisationMap.put(cacheKey, messageLocalisation);
        }
        return messageLocalisation;
    }

    private static final class CacheKey {
        private final String name;
        private final Locale locale;
        private int hashCodeCache;

        private CacheKey(String baseName, Locale locale) {
            this.name = baseName;
            this.locale = locale;
            this.calculateHashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (this == other) {
                return true;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            CacheKey otherEntry = (CacheKey)other;
            if (this.hashCodeCache != otherEntry.hashCodeCache) {
                return false;
            }
            if (!this.name.equals(otherEntry.name)) {
                return false;
            }
            return this.locale.equals(otherEntry.locale);
        }

        public int hashCode() {
            return this.hashCodeCache;
        }

        public String toString() {
            String l = this.locale.toString();
            if (l.length() == 0) {
                l = this.locale.getVariant().length() != 0 ? "__" + this.locale.getVariant() : "\"\"";
            }
            return "CacheKey[" + this.name + ", lc=" + l + "]";
        }

        private void calculateHashCode() {
            this.hashCodeCache = this.name.hashCode() << 3;
            this.hashCodeCache ^= this.locale.hashCode();
        }
    }
}

