/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.images;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.mapeadores.util.awt.ResizeInfo;
import net.mapeadores.util.images.ImagesUtils;
import net.mapeadores.util.logging.ErrorMessageException;

public final class ImageResizing {
    private ImageResizing() {
    }

    public static void resize(File srcFile, File destFile, ResizeInfo resizeInfo, String format) throws IOException, ErrorMessageException {
        BufferedImage srcImg = ImagesUtils.read(srcFile);
        BufferedImage destImg = ImageResizing.getScaledInstance(srcImg, resizeInfo);
        ImagesUtils.write(destImg, format, destFile);
    }

    public static void resize(InputStream inputStream, OutputStream outputStream, ResizeInfo resizeInfo, String format) throws IOException, ErrorMessageException {
        BufferedImage srcImg = ImagesUtils.read(inputStream);
        BufferedImage destImg = ImageResizing.getScaledInstance(srcImg, resizeInfo);
        ImagesUtils.write(destImg, format, outputStream);
    }

    public static void resize(InputStream inputStream, File destFile, ResizeInfo resizeInfo, String format) throws IOException, ErrorMessageException {
        BufferedImage srcImg = ImagesUtils.read(inputStream);
        BufferedImage destImg = ImageResizing.getScaledInstance(srcImg, resizeInfo);
        ImagesUtils.write(destImg, format, destFile);
    }

    public static BufferedImage getScaledInstance(BufferedImage img, ResizeInfo resizeInfo) {
        int width = img.getWidth();
        int height = img.getHeight();
        short type = resizeInfo.getType();
        int targetWidth = resizeInfo.getWidth();
        int targetHeight = resizeInfo.getHeight();
        if (resizeInfo.isOnlyMax()) {
            switch (type) {
                case 1: {
                    if (width > targetWidth) break;
                    return img;
                }
                case 2: {
                    if (height > targetHeight) break;
                    return img;
                }
                case 3: {
                    if (width > targetWidth || height > targetHeight) break;
                    return img;
                }
            }
        }
        float ratio = 0.0f;
        switch (type) {
            case 1: {
                if (targetWidth == width) {
                    return img;
                }
                ratio = (float)targetWidth / (float)width;
                targetHeight = (int)(ratio * (float)height);
                break;
            }
            case 2: {
                if (targetHeight == height) {
                    return img;
                }
                ratio = (float)targetHeight / (float)height;
                targetWidth = (int)(ratio * (float)width);
                break;
            }
            case 3: {
                if (resizeInfo.isOnlyMax()) {
                    float widthRatio = (float)targetWidth / (float)width;
                    float heightRatio = (float)targetHeight / (float)height;
                    if (widthRatio < heightRatio) {
                        ratio = widthRatio;
                        targetHeight = (int)(ratio * (float)height);
                        break;
                    }
                    ratio = heightRatio;
                    targetWidth = (int)(ratio * (float)width);
                    break;
                }
                ratio = Math.max((float)targetWidth / (float)width, (float)targetHeight / (float)height);
            }
        }
        if (ratio > 1.0f) {
            return ImageResizing.getScaledInstance(img, targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_BICUBIC, false);
        }
        return ImageResizing.getScaledInstance(img, targetWidth, targetHeight, RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
    }

    public static BufferedImage getScaledInstance(BufferedImage img, int targetWidth, int targetHeight, Object hint, boolean higherQuality) {
        int h;
        int w;
        int type = img.getTransparency() == 1 ? 1 : 2;
        BufferedImage ret = img;
        if (higherQuality) {
            w = img.getWidth();
            h = img.getHeight();
        } else {
            w = targetWidth;
            h = targetHeight;
        }
        do {
            if (higherQuality && w > targetWidth && (w /= 2) < targetWidth) {
                w = targetWidth;
            }
            if (higherQuality && h > targetHeight && (h /= 2) < targetHeight) {
                h = targetHeight;
            }
            BufferedImage tmp = new BufferedImage(w, h, type);
            Graphics2D g2 = tmp.createGraphics();
            g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, hint);
            g2.drawImage(ret, 0, 0, w, h, null);
            g2.dispose();
            ret = tmp;
        } while (w != targetWidth || h != targetHeight);
        return ret;
    }
}

