/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.html;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.localisation.LocalisationUtils;
import net.mapeadores.util.localisation.Message;
import net.mapeadores.util.text.StringUtils;

public class HtmlAttributes
implements Serializable,
Cloneable {
    public static final short NONE = 0;
    public static final short STRING = 1;
    public static final short LOCKEY = 2;
    public static final short MESSAGE = 3;
    private String name;
    private String classes;
    private String id;
    private String style;
    private String target;
    private String href;
    private String src;
    private String alt;
    private Object title;
    private short titleType = 0;
    private String width;
    private String height;
    private String size;
    private String value;
    private String type;
    private String action;
    private String method;
    private String label;
    private String rel;
    private String content;
    private String httpEquiv;
    private String enctype;
    private String forId;
    private String pattern;
    private boolean checked;
    private boolean selected;
    private boolean disabled;
    private boolean readonly;
    private boolean multiple;
    private boolean required;
    private boolean open;
    private int colSpan;
    private int rowSpan;
    private int cols;
    private int rows;
    private Map<String, String> attrMap = null;

    public HtmlAttributes copy() {
        try {
            return (HtmlAttributes)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new ShouldNotOccurException(e);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public String classes() {
        return this.classes;
    }

    public HtmlAttributes classes(String className) {
        this.classes = className;
        return this;
    }

    public HtmlAttributes addClass(boolean addCondition, String className) {
        if (addCondition) {
            return this.addClass(className);
        }
        return this;
    }

    public HtmlAttributes addClass(String className) {
        if (className == null || className.length() == 0) {
            return this;
        }
        this.classes = this.classes == null || this.classes.length() == 0 ? className : this.classes + " " + className;
        return this;
    }

    public String id() {
        return this.id;
    }

    public HtmlAttributes id(String id) {
        this.id = id;
        return this;
    }

    public String forId() {
        return this.forId;
    }

    public HtmlAttributes forId(String forId) {
        this.forId = forId;
        return this;
    }

    public String name() {
        return this.name;
    }

    public HtmlAttributes name(String name) {
        this.name = name;
        return this;
    }

    public String style() {
        return this.style;
    }

    public HtmlAttributes style(String style) {
        this.style = style;
        return this;
    }

    public String target() {
        return this.target;
    }

    public HtmlAttributes target(String target) {
        this.target = target;
        return this;
    }

    public String href() {
        return this.href;
    }

    public HtmlAttributes href(CharSequence href) {
        this.href = href.toString();
        return this;
    }

    public String width() {
        return this.width;
    }

    public HtmlAttributes width(String width) {
        this.width = width;
        return this;
    }

    public String height() {
        return this.height;
    }

    public HtmlAttributes height(String height) {
        this.height = height;
        return this;
    }

    public Object title() {
        return this.title;
    }

    public short getTitleType() {
        return this.titleType;
    }

    public HtmlAttributes title(String title) {
        this.title = title;
        this.titleType = title != null ? (short)1 : 0;
        return this;
    }

    public HtmlAttributes titleLocKey(String titleLocKey) {
        this.title = titleLocKey;
        this.titleType = this.title != null ? (short)2 : (short)0;
        return this;
    }

    public HtmlAttributes titleMessage(String titleLocKey, Object ... values) {
        if (values == null) {
            return this.titleLocKey(titleLocKey);
        }
        this.titleType = (short)3;
        this.title = LocalisationUtils.toMessage(titleLocKey, values);
        return this;
    }

    public HtmlAttributes titleMessage(Message titleMessage) {
        this.title = titleMessage;
        this.titleType = this.title != null ? (short)3 : (short)0;
        return this;
    }

    public String src() {
        return this.src;
    }

    public HtmlAttributes src(CharSequence href) {
        this.src = href.toString();
        return this;
    }

    public String alt() {
        return this.alt;
    }

    public HtmlAttributes alt(String alt) {
        this.alt = alt;
        return this;
    }

    public String size() {
        return this.size;
    }

    public HtmlAttributes size(String size) {
        this.size = size;
        return this;
    }

    public HtmlAttributes value(String value) {
        this.value = value;
        return this;
    }

    public HtmlAttributes value(Map<String, String> valueMap) {
        if (this.name != null) {
            this.value = valueMap.get(this.name);
        }
        return this;
    }

    public String value() {
        return this.value;
    }

    public HtmlAttributes type(String type) {
        this.type = type;
        return this;
    }

    public String type() {
        return this.type;
    }

    public boolean checked() {
        return this.checked;
    }

    public HtmlAttributes checked(boolean checked) {
        this.checked = checked;
        return this;
    }

    public HtmlAttributes checked(Map<String, String> valueMap) {
        String current;
        if (this.name != null && this.value != null && (current = valueMap.get(this.name)) != null) {
            String[] tokens = StringUtils.getTokens(current, ';', (short)0);
            boolean checked = false;
            for (String token : tokens) {
                if (!token.equals(this.value)) continue;
                checked = true;
            }
            this.checked = checked;
        }
        return this;
    }

    public HtmlAttributes checked(String currentValue) {
        if (this.value != null) {
            this.checked = currentValue != null && this.value.equals(currentValue);
        }
        return this;
    }

    public boolean selected() {
        return this.selected;
    }

    public HtmlAttributes selected(boolean selected) {
        this.selected = selected;
        return this;
    }

    public boolean disabled() {
        return this.disabled;
    }

    public HtmlAttributes disabled(boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    public boolean open() {
        return this.open;
    }

    public HtmlAttributes open(boolean open) {
        this.open = open;
        return this;
    }

    public boolean multiple() {
        return this.multiple;
    }

    public HtmlAttributes multiple(boolean multiple) {
        this.multiple = multiple;
        return this;
    }

    public String action() {
        return this.action;
    }

    public HtmlAttributes action(String action) {
        this.action = action;
        return this;
    }

    public String method() {
        return this.method;
    }

    public HtmlAttributes method(String method) {
        this.method = method;
        return this;
    }

    public int colspan() {
        return this.colSpan;
    }

    public HtmlAttributes colspan(int colSpan) {
        this.colSpan = colSpan;
        return this;
    }

    public int rowspan() {
        return this.rowSpan;
    }

    public HtmlAttributes rowspan(int rowSpan) {
        this.rowSpan = rowSpan;
        return this;
    }

    public String label() {
        return this.label;
    }

    public HtmlAttributes label(String label) {
        this.label = label;
        return this;
    }

    public int cols() {
        return this.cols;
    }

    public HtmlAttributes cols(int cols) {
        this.cols = cols;
        return this;
    }

    public int rows() {
        return this.rows;
    }

    public HtmlAttributes rows(int rows) {
        this.rows = rows;
        return this;
    }

    public boolean readonly() {
        return this.readonly;
    }

    public HtmlAttributes readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }

    public String rel() {
        return this.rel;
    }

    public HtmlAttributes rel(String rel) {
        this.rel = rel;
        return this;
    }

    public String content() {
        return this.content;
    }

    public HtmlAttributes content(String content) {
        this.content = content;
        return this;
    }

    public String pattern() {
        return this.pattern;
    }

    public HtmlAttributes pattern(String pattern) {
        this.pattern = pattern;
        return this;
    }

    public String httpEquiv() {
        return this.httpEquiv;
    }

    public HtmlAttributes httpEquiv(String httpEquiv) {
        this.httpEquiv = httpEquiv;
        return this;
    }

    public String enctype() {
        return this.enctype;
    }

    public HtmlAttributes enctype(String enctype) {
        this.enctype = enctype;
        return this;
    }

    public boolean required() {
        return this.required;
    }

    public HtmlAttributes required(boolean required) {
        this.required = required;
        return this;
    }

    public HtmlAttributes attr(String name, String value) {
        if (value == null) {
            if (this.attrMap != null) {
                this.attrMap.remove(name);
            }
        } else {
            if (this.attrMap == null) {
                this.attrMap = new HashMap<String, String>();
            }
            this.attrMap.put(name, value);
        }
        return this;
    }

    public HtmlAttributes attr(boolean addCondition, String name, String value) {
        if (addCondition) {
            return this.attr(name, value);
        }
        return this;
    }

    public String attr(String name) {
        if (this.attrMap == null) {
            return null;
        }
        return this.attrMap.get(name);
    }

    public Map<String, String> getAttrMap() {
        return this.attrMap;
    }

    public HtmlAttributes populate(Consumer<HtmlAttributes> consumer) {
        consumer.accept(this);
        return this;
    }
}

