/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.geometry;

import java.awt.Dimension;
import java.awt.Point;

public class CartesianPoint
extends Point {
    public CartesianPoint(int x, int y) {
        super(x, y);
    }

    public CartesianPoint() {
    }

    public CartesianPoint(CartesianPoint cartesianPoint) {
        super(cartesianPoint);
    }

    public static CartesianPoint convertToCartesianPoint(double theta, double r) {
        int x = (int)Math.round(r * Math.cos(theta));
        int y = (int)Math.round(r * Math.sin(theta));
        return new CartesianPoint(x, y);
    }

    public static double angle(CartesianPoint C, CartesianPoint A) {
        return CartesianPoint.angle(A.x - C.x, A.y - C.y);
    }

    public static double angle(CartesianPoint A) {
        return CartesianPoint.angle(A.x, A.y);
    }

    public static double angle(int x, int y) {
        double theta = Math.acos((double)x / CartesianPoint.norme(x, y));
        if (y < 0) {
            theta = Math.PI * 2 - theta;
        }
        return theta;
    }

    public static double norme(CartesianPoint A) {
        return CartesianPoint.norme(A.x, A.y);
    }

    public static double norme(int x, int y) {
        return Math.sqrt(x * x + y * y);
    }

    public static double norme(double x, double y) {
        return Math.sqrt(x * x + y * y);
    }

    public static double norme(CartesianPoint C, CartesianPoint A) {
        return CartesianPoint.norme(A.x - C.x, A.y - C.y);
    }

    public static CartesianPoint getCartesianPointOnEllipse(CartesianPoint C, double angle, Dimension ab) {
        double r = CartesianPoint.getNormeOnEllipse(angle, ab);
        int x = (int)Math.round(Math.cos(angle) * r);
        int y = (int)Math.round(Math.sin(angle) * r);
        return new CartesianPoint(x + C.x, y + C.y);
    }

    public static double getNormeOnEllipse(double angle, Dimension ab) {
        double costheta = Math.cos(angle);
        double sintheta = Math.sin(angle);
        int acarre = ab.width * ab.width;
        int bcarre = ab.height * ab.height;
        double r = Math.sqrt(1.0 / (costheta * costheta / (double)acarre + sintheta * sintheta / (double)bcarre));
        return r;
    }
}

