/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.util.attr;

import java.io.IOException;
import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeBuffer;
import net.mapeadores.util.attr.AttributeChange;
import net.mapeadores.util.attr.AttributeDef;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.AttributeKeyAlias;
import net.mapeadores.util.attr.Attributes;
import net.mapeadores.util.attr.CheckedLocalKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.instruction.Argument;
import net.mapeadores.util.instruction.Instruction;
import net.mapeadores.util.instruction.InstructionErrorHandler;
import net.mapeadores.util.instruction.InstructionParser;
import net.mapeadores.util.instruction.InstructionUtils;
import net.mapeadores.util.logging.LogUtils;
import net.mapeadores.util.logging.MessageHandler;
import net.mapeadores.util.text.CleanedString;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.Labels;
import net.mapeadores.util.text.Phrases;
import net.mapeadores.util.xml.DOMUtils;
import net.mapeadores.util.xml.DomMessages;
import net.mapeadores.util.xml.XMLUtils;
import net.mapeadores.util.xml.XMLWriter;
import org.w3c.dom.Element;

public final class AttributeUtils {
    public static final List<AttributeKey> EMPTY_ATTRIBUTEKEYLIST = Collections.emptyList();
    public static final List<AttributeDef> EMPTY_ATTRIBUTEDEFLIST = Collections.emptyList();
    public static final AttributeChange EMPTY_ATTRIBUTECHANGE = new EmptyAttributeChange();
    public static final Attributes EMPTY_ATTRIBUTES = new EmptyAttributes();
    public static final Predicate<AttributeKey> NONE_PREDICATE = new BooleanPredicate(false);
    public static final Predicate<AttributeKey> ALL_PREDICATE = new BooleanPredicate(true);

    private AttributeUtils() {
    }

    public static boolean isEqual(Attribute attr1, Attribute attr2) {
        boolean test1 = attr1.getAttributeKey().equals(attr2.getAttributeKey());
        if (!test1) {
            return false;
        }
        int valueLength = attr1.size();
        if (valueLength != attr2.size()) {
            return false;
        }
        for (int i = 0; i < valueLength; ++i) {
            if (((String)attr1.get(i)).equals(attr2.get(i))) continue;
            return false;
        }
        return true;
    }

    public static Attributes toSingletonAttributes(Attribute attribute) {
        if (attribute == null) {
            throw new IllegalArgumentException("attribute is null");
        }
        return new SingletonAttributes(attribute);
    }

    public static AttributeDef toDefaultAttributeDef(AttributeKey attributeKey) {
        if (attributeKey == null) {
            throw new IllegalArgumentException("attributeKey is null");
        }
        return new DefaultAttributeDef(attributeKey);
    }

    public static void addAttributes(XMLWriter xmlWriter, Attributes attributes) throws IOException {
        int length = attributes.size();
        for (int i = 0; i < length; ++i) {
            AttributeUtils.addAttribute(xmlWriter, (Attribute)attributes.get(i));
        }
    }

    public static void readAttrElement(AttributeBuffer attributeBuffer, Element element) {
        AttributeUtils.readAttrElement(attributeBuffer, element, LogUtils.NULL_MULTIMESSAGEHANDLER, "", null);
    }

    public static void readAttrElement(AttributeBuffer attributeBuffer, Element element, AttributeKeyAlias attributeKeyAlias) {
        AttributeUtils.readAttrElement(attributeBuffer, element, LogUtils.NULL_MULTIMESSAGEHANDLER, "", attributeKeyAlias);
    }

    public static void readAttrElement(AttributeBuffer attributeBuffer, Element element, MessageHandler messageHandler, String xpath) {
        AttributeUtils.readAttrElement(attributeBuffer, element, messageHandler, xpath, null);
    }

    public static void readAttrElement(AttributeBuffer attributeBuffer, Element element, MessageHandler messageHandler, String xpath, AttributeKeyAlias attributeKeyAlias) {
        AttributeKey attributeKey = AttributeUtils.readAttributeKey(element, messageHandler, xpath, attributeKeyAlias);
        if (attributeKey == null) {
            return;
        }
        DOMUtils.readChildren(element, new AttributeConsumer(attributeKey, attributeBuffer, messageHandler, xpath + "[@ns='" + attributeKey.getNameSpace() + "' AND @key='" + attributeKey.getLocalKey() + "']"));
    }

    public static AttributeKey readAttributeKey(Element element) {
        return AttributeUtils.readAttributeKey(element, LogUtils.NULL_MULTIMESSAGEHANDLER, "");
    }

    public static AttributeKey readAttributeKey(Element element, MessageHandler messageHandler, String xpath) {
        return AttributeUtils.readAttributeKey(element, messageHandler, xpath, null);
    }

    public static AttributeKey readAttributeKey(Element element, MessageHandler messageHandler, String xpath, AttributeKeyAlias attributeKeyAlias) {
        CheckedLocalKey localKey;
        CheckedNameSpace nameSpace;
        String nameSpaceString = element.getAttribute("ns");
        if (nameSpaceString.length() == 0) {
            DomMessages.emptyAttribute(messageHandler, xpath, "ns");
            return null;
        }
        String localKeyString = element.getAttribute("key");
        if (localKeyString.length() == 0) {
            DomMessages.emptyAttribute(messageHandler, xpath, "key");
            return null;
        }
        xpath = xpath + "[@ns='" + nameSpaceString + "' AND @key='" + localKeyString + "']";
        if (attributeKeyAlias != null) {
            nameSpaceString = attributeKeyAlias.checkNameSpace(nameSpaceString);
            localKeyString = attributeKeyAlias.checkLocalKey(localKeyString);
        }
        try {
            nameSpace = CheckedNameSpace.parse(nameSpaceString);
        }
        catch (ParseException pe) {
            DomMessages.wrongAttributeValue(messageHandler, xpath, "ns", nameSpaceString);
            return null;
        }
        try {
            localKey = CheckedLocalKey.parse(localKeyString);
        }
        catch (ParseException pe) {
            DomMessages.wrongAttributeValue(messageHandler, xpath, "key", localKeyString);
            return null;
        }
        return AttributeKey.build(nameSpace, localKey);
    }

    public static List<AttributeDef> toImmutableList(Collection<AttributeDef> attributeDefs) {
        return AttributeUtils.wrap(attributeDefs.toArray(new AttributeDef[attributeDefs.size()]));
    }

    public static List<AttributeDef> wrap(AttributeDef[] array) {
        return new AttributeDefList(array);
    }

    public static List<AttributeKey> wrap(AttributeKey[] array) {
        return new AttributeKeyList(array);
    }

    public static void parseInstruction(AttributeBuffer attributeBuffer, String s, CheckedNameSpace defaultNameSpace, InstructionErrorHandler errorHandler) {
        Instruction instruction;
        if (errorHandler == null) {
            errorHandler = InstructionUtils.DEFAULT_ERROR_HANDLER;
        }
        if ((instruction = InstructionParser.parse(s, errorHandler)) == null) {
            return;
        }
        for (Argument argument : instruction) {
            CleanedString cleanedString = CleanedString.newInstance(argument.getValue());
            if (cleanedString == null) continue;
            try {
                AttributeKey attributeKey = AttributeUtils.parse(argument.getKey(), defaultNameSpace);
                attributeBuffer.appendValue(attributeKey, cleanedString);
            }
            catch (ParseException parseException) {}
        }
    }

    private static AttributeKey parse(String key, CheckedNameSpace defaultNameSpace) throws ParseException {
        if (defaultNameSpace == null) {
            return AttributeKey.parse(key);
        }
        CheckedLocalKey localKey = CheckedLocalKey.parse(key);
        return AttributeKey.build(defaultNameSpace, localKey);
    }

    public static void addAttribute(XMLWriter xmlWriter, Attribute attribute) throws IOException {
        AttributeKey key = attribute.getAttributeKey();
        String nameSpace = key.getNameSpace();
        if (nameSpace.equals("_transient")) {
            return;
        }
        xmlWriter.startOpenTag("attr").addAttribute("ns", nameSpace).addAttribute("key", key.getLocalKey()).endOpenTag();
        int valueLength = attribute.size();
        for (int i = 0; i < valueLength; ++i) {
            xmlWriter.addSimpleElement("val", (String)attribute.get(i));
        }
        xmlWriter.closeTag("attr");
    }

    public static Predicate<AttributeKey> toAttributeKeyPredicate(Collection<String> filters) {
        if (filters.isEmpty()) {
            return NONE_PREDICATE;
        }
        HashSet<String> equalSet = new HashSet<String>();
        ArrayList<String> prefixList = new ArrayList<String>();
        for (String filter : filters) {
            if (filter.equals("*")) {
                return ALL_PREDICATE;
            }
            if (filter.endsWith("*")) {
                prefixList.add(filter.substring(0, filter.length() - 1));
                continue;
            }
            equalSet.add(filter);
        }
        return new FilterPredicate(equalSet, prefixList);
    }

    private static class SingletonAttributes
    extends AbstractList<Attribute>
    implements Attributes {
        private final Attribute attribute;

        private SingletonAttributes(Attribute attribute) {
            this.attribute = attribute;
        }

        @Override
        public Attribute getAttribute(AttributeKey key) {
            if (this.attribute.getAttributeKey().equals(key)) {
                return this.attribute;
            }
            return null;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public Attribute get(int i) {
            if (i != 0) {
                throw new IndexOutOfBoundsException();
            }
            return this.attribute;
        }
    }

    private static class DefaultAttributeDef
    implements AttributeDef {
        private final AttributeKey attributeKey;

        private DefaultAttributeDef(AttributeKey attributeKey) {
            this.attributeKey = attributeKey;
        }

        @Override
        public AttributeKey getAttributeKey() {
            return this.attributeKey;
        }

        @Override
        public Object getDefObject(String objectName) {
            return null;
        }

        @Override
        public Labels getTitleLabels() {
            return LabelUtils.EMPTY_LABELS;
        }

        @Override
        public Phrases getPhrases() {
            return LabelUtils.EMPTY_PHRASES;
        }

        @Override
        public Attributes getAttributes() {
            return EMPTY_ATTRIBUTES;
        }
    }

    private static class AttributeConsumer
    implements Consumer<Element> {
        private final AttributeKey attributeKey;
        private final AttributeBuffer attributeBuffer;
        private final MessageHandler messageHandler;
        private final String xpath;

        public AttributeConsumer(AttributeKey attributeKey, AttributeBuffer attributesBuilder, MessageHandler messageHandler, String xpath) {
            this.attributeKey = attributeKey;
            this.attributeBuffer = attributesBuilder;
            this.messageHandler = messageHandler;
            this.xpath = xpath;
        }

        @Override
        public void accept(Element element) {
            String tagName = element.getTagName();
            String currentXpath = this.xpath + "/" + tagName;
            if (tagName.equals("val")) {
                CleanedString cs = XMLUtils.toCleanedString(element);
                if (cs != null) {
                    this.attributeBuffer.appendValue(this.attributeKey, cs);
                } else {
                    DomMessages.emptyElement(this.messageHandler, currentXpath);
                }
            } else {
                DomMessages.unknownTagWarning(this.messageHandler, currentXpath);
            }
        }
    }

    private static class AttributeDefList
    extends AbstractList<AttributeDef>
    implements RandomAccess {
        private final AttributeDef[] array;

        private AttributeDefList(AttributeDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AttributeDef get(int index) {
            return this.array[index];
        }
    }

    private static class AttributeKeyList
    extends AbstractList<AttributeKey>
    implements RandomAccess {
        private final AttributeKey[] array;

        private AttributeKeyList(AttributeKey[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public AttributeKey get(int index) {
            return this.array[index];
        }
    }

    private static class FilterPredicate
    implements Predicate<AttributeKey> {
        private final Set<String> equalSet;
        private final List<String> prefixList;

        private FilterPredicate(Set<String> equalSet, List<String> startsWithList) {
            this.equalSet = equalSet;
            this.prefixList = startsWithList;
        }

        @Override
        public boolean test(AttributeKey attributeKey) {
            String text = attributeKey.toString();
            if (this.equalSet.contains(text)) {
                return true;
            }
            for (String prefix : this.prefixList) {
                if (!text.startsWith(prefix)) continue;
                return true;
            }
            return false;
        }
    }

    private static class EmptyAttributeChange
    implements AttributeChange {
        private EmptyAttributeChange() {
        }

        @Override
        public List<AttributeKey> getRemovedAttributeKeyList() {
            return EMPTY_ATTRIBUTEKEYLIST;
        }

        @Override
        public Attributes getChangedAttributes() {
            return EMPTY_ATTRIBUTES;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }

    private static class EmptyAttributes
    extends AbstractList<Attribute>
    implements Attributes {
        private EmptyAttributes() {
        }

        @Override
        public Attribute getAttribute(AttributeKey key) {
            return null;
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public Attribute get(int i) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class BooleanPredicate
    implements Predicate<AttributeKey> {
        private final boolean value;

        private BooleanPredicate(boolean value) {
            this.value = value;
        }

        @Override
        public boolean test(AttributeKey attributeKey) {
            return this.value;
        }
    }
}

