/*
 * Decompiled with CFR 0.152.
 */
package net.mapeadores.opendocument.elements;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.mapeadores.opendocument.elements.Constants;
import net.mapeadores.opendocument.elements.OdAttribute;
import net.mapeadores.opendocument.elements.OdAttributeMap;
import net.mapeadores.opendocument.elements.OdElementUtils;

public abstract class OdElement
implements Constants {
    private final Map<OdAttribute, String>[] attributeMapArray = new Map[12];

    private Map<OdAttribute, String> getOrCreateAttributeMap(int attributeType) {
        Map<OdAttribute, String> map = this.attributeMapArray[attributeType - 1];
        if (map == null) {
            this.attributeMapArray[attributeType - 1] = map = new HashMap<OdAttribute, String>();
        }
        return map;
    }

    public void importAttributes(OdElement importElement) {
        for (int i = 0; i < 12; ++i) {
            Map<OdAttribute, String> map = importElement.attributeMapArray[i];
            if (map == null) continue;
            Map<OdAttribute, String> destinationMap = this.attributeMapArray[i];
            if (destinationMap == null) {
                this.attributeMapArray[i] = destinationMap = new HashMap<OdAttribute, String>(map);
                continue;
            }
            for (Map.Entry<OdAttribute, String> entry : map.entrySet()) {
                OdAttribute key = entry.getKey();
                if (destinationMap.containsKey(entry.getKey())) continue;
                destinationMap.put(key, entry.getValue());
            }
        }
    }

    public OdElement putAttribute(String name, String value) {
        int[] avalaibleTypeArray = this.getAvalaibleTypeArray();
        OdAttribute attribute = OdAttributeMap.getAttribute(avalaibleTypeArray, name);
        if (attribute == null) {
            return this;
        }
        Map<OdAttribute, String> map = this.getOrCreateAttributeMap(attribute.getAttributeType());
        if (OdElementUtils.isStyleNameAttribute(name)) {
            value = OdElementUtils.checkStyleNameValue(value);
        }
        map.put(attribute, value);
        return this;
    }

    public Map<OdAttribute, String> getAttributeMap(int attributeType) {
        Map<OdAttribute, String> map = this.attributeMapArray[attributeType - 1];
        if (map == null) {
            return Collections.emptyMap();
        }
        return map;
    }

    public abstract int[] getAvalaibleTypeArray();
}

