/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.storage;

import java.io.IOException;
import java.util.List;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeXMLUtils;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.MultiStringable;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class CorpusMetadataXMLPart
extends XMLPart {
    public CorpusMetadataXMLPart(XMLWriter xmlWriter) {
        super(xmlWriter);
    }

    public void appendCorpusMetadata(CorpusMetadata corpusMetadata) throws IOException {
        this.openTag("corpus-metadata");
        FichothequeXMLUtils.write(corpusMetadata, this);
        this.appendFields(corpusMetadata);
        this.appendFieldGeneration(corpusMetadata);
        this.appendOptions(corpusMetadata);
        this.appendL10n(corpusMetadata);
        this.closeTag("corpus-metadata");
    }

    private void appendFields(CorpusMetadata corpusMetadata) throws IOException {
        this.openTag("fields");
        if (corpusMetadata.isWithSoustitre()) {
            this.addEmptyElement("soustitre");
        }
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            this.startOpenTag("propriete");
            this.addAttribute("name", corpusField.getFieldName());
            this.appendFicheItemAttribute(corpusField);
            this.closeEmptyTag();
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            this.startOpenTag("information");
            this.addAttribute("name", corpusField.getFieldName());
            this.appendFicheItemAttribute(corpusField);
            this.closeEmptyTag();
        }
        for (CorpusField corpusField : corpusMetadata.getSectionList()) {
            this.startOpenTag("section");
            this.addAttribute("name", corpusField.getFieldName());
            this.closeEmptyTag();
        }
        this.closeTag("fields");
    }

    private void appendFicheItemAttribute(CorpusField corpusField) throws IOException {
        this.addAttribute("fiche-item", corpusField.getFicheItemTypeString());
    }

    private void appendL10n(CorpusMetadata corpusMetadata) throws IOException {
        this.openTag("l10n");
        List<CorpusField> list = CorpusMetadataUtils.getCorpusFieldList(corpusMetadata);
        for (CorpusField corpusField : list) {
            this.startOpenTag("field");
            this.addAttribute("field-key", corpusField.getFieldString());
            this.endOpenTag();
            LabelUtils.addLabels(this, corpusField.getLabels());
            this.closeTag("field");
        }
        this.closeTag("l10n");
    }

    private void appendFieldGeneration(CorpusMetadata corpusMetadata) throws IOException {
        String rawString = corpusMetadata.getFieldGeneration().getRawString();
        if (!rawString.isEmpty()) {
            this.openTag("field-generation");
            this.addCData(rawString);
            this.closeTag("field-generation", false);
        }
    }

    private void appendOptions(CorpusMetadata corpusMetadata) throws IOException {
        this.openTag("options");
        CorpusField geolocalisationField = corpusMetadata.getGeolocalisationField();
        if (geolocalisationField != null) {
            String value = null;
            this.appendOption("geolocalisationField", value, geolocalisationField);
        }
        this.appendOptions(corpusMetadata.getCorpusField(FieldKey.ID));
        this.appendOptions(corpusMetadata.getCorpusField(FieldKey.TITRE));
        this.appendOptions(corpusMetadata.getCorpusField(FieldKey.LANG));
        this.appendOptions(corpusMetadata.getCorpusField(FieldKey.REDACTEURS));
        CorpusField soustitre = corpusMetadata.getCorpusField(FieldKey.SOUSTITRE);
        if (soustitre != null) {
            this.appendOptions(soustitre);
        }
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            this.appendOptions(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            this.appendOptions(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getSectionList()) {
            this.appendOptions(corpusField);
        }
        this.closeTag("options");
    }

    private void appendOptions(CorpusField corpusField) throws IOException {
        for (String optionName : corpusField.getOptionNameSet()) {
            Object value = corpusField.getOption(optionName);
            if (value instanceof String) {
                this.appendOption(optionName, (String)value, corpusField);
                continue;
            }
            if (!(value instanceof MultiStringable)) continue;
            this.appendOption(optionName, ((MultiStringable)value).toStringArray(), corpusField);
        }
    }

    private void appendOption(String name, String value, CorpusField corpusField) throws IOException {
        this.startOpenTag("option");
        this.addAttribute("name", name);
        this.addAttribute("field-key", corpusField.getFieldString());
        this.addAttribute("value", value);
        this.closeEmptyTag();
    }

    private void appendOption(String name, String[] values, CorpusField corpusField) throws IOException {
        this.startOpenTag("option");
        this.addAttribute("name", name);
        this.addAttribute("field-key", corpusField.getFieldString());
        this.endOpenTag();
        for (String value : values) {
            if (value != null && value.length() > 0) {
                this.addSimpleElement("value", value);
                continue;
            }
            this.addEmptyElement("value");
        }
        this.closeTag("option");
    }
}

