/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.xml.extraction;

import java.io.IOException;
import java.text.DecimalFormatSymbols;
import java.text.ParseException;
import java.util.Locale;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.fiche.Courriel;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Geopoint;
import net.fichotheque.corpus.fiche.Image;
import net.fichotheque.corpus.fiche.Item;
import net.fichotheque.corpus.fiche.Langue;
import net.fichotheque.corpus.fiche.Link;
import net.fichotheque.corpus.fiche.Montant;
import net.fichotheque.corpus.fiche.Nombre;
import net.fichotheque.corpus.fiche.Para;
import net.fichotheque.corpus.fiche.Pays;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.extraction.ExtractParameters;
import net.fichotheque.extraction.ExtractionContext;
import net.fichotheque.extraction.IrefConverter;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.SphereUtils;
import net.fichotheque.xml.extraction.FicheBlockXMLPart;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.localisation.LangContext;
import net.mapeadores.util.localisation.ListLangContext;
import net.mapeadores.util.localisation.SpecialCodes;
import net.mapeadores.util.localisation.UserLangContext;
import net.mapeadores.util.models.EmailCore;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.money.ExtendedCurrency;
import net.mapeadores.util.money.MoneyUtils;
import net.mapeadores.util.primitives.Decimal;
import net.mapeadores.util.primitives.DegreDecimal;
import net.mapeadores.util.primitives.DegreSexagesimal;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.DateFormatBundle;
import net.mapeadores.util.text.LabelUtils;
import net.mapeadores.util.text.StringUtils;
import net.mapeadores.util.xml.XMLPart;
import net.mapeadores.util.xml.XMLWriter;

public class FicheItemXMLPart
extends XMLPart {
    private final ExtractParameters extractParameters;
    private final FicheBlockXMLPart ficheBlockXMLPart;
    private final ExtractionContext extractionContext;
    private final int extractVersion;

    public FicheItemXMLPart(XMLWriter xmlWriter, ExtractParameters extractParameters) {
        super(xmlWriter);
        this.extractParameters = extractParameters;
        this.extractionContext = extractParameters.getExtractionContext();
        this.extractVersion = extractParameters.getExtractVersion();
        this.ficheBlockXMLPart = new FicheBlockXMLPart(xmlWriter, extractParameters);
    }

    public void addFicheItems(FicheItems ficheItems, Object fieldOptionObject, IrefConverter irefConverter) throws IOException {
        int size = ficheItems.size();
        for (int i = 0; i < size; ++i) {
            this.addFicheItem((FicheItem)ficheItems.get(i), fieldOptionObject, irefConverter);
        }
    }

    public void addFicheItem(FicheItem ficheItem, Object fieldOptionObject, IrefConverter irefConverter) throws IOException {
        if (ficheItem instanceof Item) {
            this.addItem((Item)ficheItem);
        } else if (ficheItem instanceof Personne) {
            this.addPersonne((Personne)ficheItem);
        } else if (ficheItem instanceof Datation) {
            this.addDatation((Datation)ficheItem, fieldOptionObject);
        } else if (ficheItem instanceof Langue) {
            this.addLangue((Langue)ficheItem);
        } else if (ficheItem instanceof Pays) {
            this.addPays((Pays)ficheItem);
        } else if (ficheItem instanceof Link) {
            this.addLink((Link)ficheItem, fieldOptionObject);
        } else if (ficheItem instanceof Courriel) {
            this.addCourriel((Courriel)ficheItem);
        } else if (ficheItem instanceof Montant) {
            this.addMontant((Montant)ficheItem, fieldOptionObject);
        } else if (ficheItem instanceof Nombre) {
            this.addNombre((Nombre)ficheItem);
        } else if (ficheItem instanceof Geopoint) {
            this.addGeopoint((Geopoint)ficheItem);
        } else if (ficheItem instanceof Para) {
            this.addPara((Para)ficheItem, irefConverter);
        } else if (ficheItem instanceof Image) {
            this.addImage((Image)ficheItem, fieldOptionObject);
        } else {
            throw new ClassCastException("unknown instance of FicheItem = " + ficheItem.getClass().getName());
        }
    }

    public void addItem(Item item) throws IOException {
        this.addSimpleElement("item", item.getValue());
    }

    public void addCourriel(Courriel courriel) throws IOException {
        EmailCore emailCore = courriel.getEmailCore();
        String addrSpec = emailCore.getAddrSpec();
        this.startOpenTag("courriel");
        this.addAttribute("addr-spec", addrSpec);
        String realName = emailCore.getRealName();
        if (realName.length() > 0) {
            this.addAttribute("real-name", realName);
        }
        int idx = addrSpec.indexOf(64);
        this.addAttribute("user", addrSpec.substring(0, idx));
        this.addAttribute("domain", addrSpec.substring(idx + 1));
        this.endOpenTag();
        this.addText(courriel.toString());
        this.closeTag("courriel", false);
    }

    public void addDatation(Datation datation, Object fieldOptionObject) throws IOException {
        FuzzyDate date = datation.getDate();
        this.startOpenTag("datation");
        if (this.extractVersion == 1) {
            this.addAttribute("a", String.valueOf(date.getYear()));
            switch (date.getType()) {
                case 2: {
                    this.addAttribute("type", "s");
                    this.addAttribute("s", String.valueOf(date.getHalfYear()));
                    break;
                }
                case 3: {
                    this.addAttribute("type", "t");
                    this.addAttribute("t", String.valueOf(date.getQuarter()));
                    break;
                }
                case 4: {
                    this.addAttribute("type", "m");
                    this.addAttribute("m", String.valueOf(date.getMonth()));
                    break;
                }
                case 5: {
                    this.addAttribute("type", "j");
                    this.addAttribute("m", String.valueOf(date.getMonth()));
                    this.addAttribute("j", String.valueOf(date.getDay()));
                    break;
                }
                default: {
                    this.addAttribute("type", "a");
                    break;
                }
            }
        } else {
            this.addAttribute("y", String.valueOf(date.getYear()));
            switch (date.getType()) {
                case 2: {
                    this.addAttribute("type", "s");
                    this.addAttribute("s", String.valueOf(date.getHalfYear()));
                    break;
                }
                case 3: {
                    this.addAttribute("type", "q");
                    this.addAttribute("q", String.valueOf(date.getQuarter()));
                    break;
                }
                case 4: {
                    this.addAttribute("type", "m");
                    this.addAttribute("m", String.valueOf(date.getMonth()));
                    break;
                }
                case 5: {
                    this.addAttribute("type", "d");
                    this.addAttribute("m", String.valueOf(date.getMonth()));
                    this.addAttribute("d", String.valueOf(date.getDay()));
                    break;
                }
                default: {
                    this.addAttribute("type", "y");
                }
            }
        }
        this.addAttribute("iso", date.toISOString());
        this.addAttribute("sort", date.toSortString());
        this.endOpenTag();
        this.addDateLabels(datation.getDate(), fieldOptionObject);
        this.closeTag("datation");
    }

    private void addDateLabels(FuzzyDate date, Object fieldOptionObject) throws IOException {
        LangContext langContext;
        if (fieldOptionObject != null && fieldOptionObject instanceof Short) {
            short labelType = (Short)fieldOptionObject;
            date = date.truncate(labelType);
        }
        if ((langContext = this.extractionContext.getLangContext()) instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                Locale formatLocale = unit.getFormatLocale();
                DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle(formatLocale);
                LabelUtils.addLabel(this, lang, date.getDateLitteral(dateFormatBundle));
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            Locale formatLocale = userLangContext.getFormatLocale();
            DateFormatBundle dateFormatBundle = DateFormatBundle.getDateFormatBundle(formatLocale);
            LabelUtils.addLabel(this, null, date.getDateLitteral(dateFormatBundle));
        }
    }

    public void addLangue(Langue langue) throws IOException {
        String code = langue.getLang().toString();
        this.startOpenTag("langue");
        this.addAttribute("lang", code);
        this.endOpenTag();
        this.addLangLabels(code);
        this.closeTag("langue");
    }

    private void addLangLabels(String code) throws IOException {
        LangContext langContext = this.extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(lang).toString(code);
                if (message == null) continue;
                message = StringUtils.getFirstPart(message);
                LabelUtils.addLabel(this, lang, message);
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(userLangContext).toString(code);
            if (message != null) {
                message = StringUtils.getFirstPart(message);
                LabelUtils.addLabel(this, null, message);
            }
        }
    }

    public void addNombre(Nombre nombre) throws IOException {
        this.startOpenTag("nombre");
        Decimal decimal = nombre.getDecimal();
        this.addDecimalAttributes(decimal);
        this.endOpenTag();
        this.addNombreLabels(decimal);
        this.closeTag("nombre");
    }

    public void addGeopoint(Geopoint geopoint) throws IOException {
        this.startOpenTag("geopoint");
        DegreDecimal latitude = geopoint.getLatitude();
        DegreDecimal longitude = geopoint.getLongitude();
        this.addAttribute("lat", latitude.toString());
        this.addAttribute("lon", longitude.toString());
        this.endOpenTag();
        DegreSexagesimal latitudeSexa = DegreSexagesimal.fromDegreDecimal(latitude);
        DegreSexagesimal longitudeSexa = DegreSexagesimal.fromDegreDecimal(longitude);
        this.startOpenTag("latitude");
        this.addSexagesimalAttributes(latitudeSexa);
        this.endOpenTag();
        this.addSexagesimalLabels(latitudeSexa, true);
        this.closeTag("latitude");
        this.startOpenTag("longitude");
        this.addSexagesimalAttributes(longitudeSexa);
        this.endOpenTag();
        this.addSexagesimalLabels(longitudeSexa, false);
        this.closeTag("longitude");
        this.closeTag("geopoint");
    }

    private void addSexagesimalAttributes(DegreSexagesimal sexa) throws IOException {
        this.addAttribute("deg", sexa.getDegre());
        this.addAttribute("mn", sexa.getMinute());
        this.addAttribute("sec", sexa.getSeconde());
    }

    private void addSexagesimalLabels(DegreSexagesimal sexa, boolean latitude) throws IOException {
        String code = latitude ? SpecialCodes.getLatitudeSpecialCode(sexa) : SpecialCodes.getLongitudeSpecialCode(sexa);
        LangContext langContext = this.extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                StringBuilder buf = new StringBuilder();
                buf.append(sexa.toString(false, " "));
                buf.append(" ");
                String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(lang).toString(code);
                if (message != null) {
                    buf.append(message);
                } else {
                    buf.append(code);
                }
                LabelUtils.addLabel(this, lang, buf.toString());
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            StringBuilder buf = new StringBuilder();
            buf.append(sexa.toString(false, " "));
            buf.append(" ");
            String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(userLangContext).toString(code);
            if (message != null) {
                buf.append(message);
            } else {
                buf.append(code);
            }
            LabelUtils.addLabel(this, null, buf.toString());
        }
    }

    private void addNombreLabels(Decimal decimal) throws IOException {
        LangContext langContext = this.extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                Locale formatLocale = unit.getFormatLocale();
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(formatLocale);
                String strg = decimal.toString(symbols);
                LabelUtils.addLabel(this, lang, strg);
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            Locale formatLocale = userLangContext.getFormatLocale();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(formatLocale);
            String strg = decimal.toString(symbols);
            LabelUtils.addLabel(this, null, strg);
        }
    }

    public void addMontant(Montant montant, Object fieldOptionObject) throws IOException {
        this.startOpenTag("montant");
        Decimal decimal = montant.getDecimal();
        this.addDecimalAttributes(decimal);
        this.addAttribute("cur", montant.getCurrency().getCurrencyCode());
        this.endOpenTag();
        this.addMontantLabels(decimal, montant.getCurrency(), montant.toMoneyLong(), fieldOptionObject);
        this.closeTag("montant");
    }

    private void addMontantLabels(Decimal decimal, ExtendedCurrency currency, long moneyLong, Object fieldOptionObject) throws IOException {
        LangContext langContext = this.extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                Locale formatLocale = unit.getFormatLocale();
                DecimalFormatSymbols symbols = new DecimalFormatSymbols(formatLocale);
                String strg = fieldOptionObject != null && fieldOptionObject.equals("force") ? MoneyUtils.toLitteralString(moneyLong, currency, symbols, false) : MoneyUtils.toLitteralString(decimal, currency, symbols);
                LabelUtils.addLabel(this, lang, strg);
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            Locale formatLocale = userLangContext.getFormatLocale();
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(formatLocale);
            String strg = fieldOptionObject != null && fieldOptionObject.equals("force") ? MoneyUtils.toLitteralString(moneyLong, currency, symbols, false) : MoneyUtils.toLitteralString(decimal, currency, symbols);
            LabelUtils.addLabel(this, null, strg);
        }
    }

    private void addDecimalAttributes(Decimal decimal) throws IOException {
        String partieEntiere = decimal.getPartieEntiereString();
        String partieDecimale = decimal.getPartieDecimaleString();
        this.addAttribute("int", partieEntiere);
        this.addAttribute("dec", partieDecimale);
        String val = partieDecimale.length() != 0 ? partieEntiere + "." + partieDecimale : partieEntiere;
        this.addAttribute("val", val);
    }

    public void addLink(Link link, Object fieldOptionObject) throws IOException {
        this.startOpenTag("link");
        this.addAttribute("href", link.getHref());
        if (fieldOptionObject != null && fieldOptionObject instanceof String && !StringUtils.isAbsoluteUrlString(link.getHref())) {
            this.addAttribute("base-url", (String)fieldOptionObject);
        }
        this.endOpenTag();
        String title = link.getTitle();
        if (title.length() == 0) {
            title = link.getHref();
            if (title.startsWith("http://") && title.length() > 8) {
                title = title.substring(7);
            } else if (title.startsWith("https://") && title.length() > 9) {
                title = title.substring(8);
            }
        }
        this.addSimpleElement("title", title);
        this.addSimpleElement("comment", link.getComment());
        this.closeTag("link");
    }

    public void addImage(Image image, Object fieldOptionObject) throws IOException {
        this.startOpenTag("image");
        this.addAttribute("src", image.getSrc());
        if (fieldOptionObject != null && fieldOptionObject instanceof String && !StringUtils.isAbsoluteUrlString(image.getSrc())) {
            this.addAttribute("base-url", (String)fieldOptionObject);
        }
        this.endOpenTag();
        this.addSimpleElement("alt", image.getAlt());
        this.addSimpleElement("title", image.getTitle());
        this.closeTag("image");
    }

    public void addPays(Pays pays) throws IOException {
        this.startOpenTag("pays");
        this.addAttribute("country", pays.getCountry().toString());
        this.endOpenTag();
        this.addPaysLabels(pays.getCountry().toString());
        this.closeTag("pays");
    }

    private void addPaysLabels(String countryCode) throws IOException {
        LangContext langContext = this.extractionContext.getLangContext();
        if (langContext instanceof ListLangContext) {
            for (ListLangContext.Unit unit : (ListLangContext)langContext) {
                Lang lang = unit.getLang();
                String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(lang).toString(countryCode);
                if (message == null) continue;
                message = StringUtils.getFirstPart(message);
                LabelUtils.addLabel(this, lang, message);
            }
        } else if (langContext instanceof UserLangContext) {
            UserLangContext userLangContext = (UserLangContext)langContext;
            String message = this.extractionContext.getMessageLocalisationProvider().getMessageLocalisation(userLangContext).toString(countryCode);
            if (message != null) {
                message = StringUtils.getFirstPart(message);
                LabelUtils.addLabel(this, null, message);
            }
        }
    }

    public void addPersonne(Personne personne) throws IOException {
        block7: {
            this.startOpenTag("personne");
            String redacteurGlobalId = personne.getRedacteurGlobalId();
            if (redacteurGlobalId != null) {
                try {
                    SubsetKey sphereKey = SphereUtils.getSubsetKey(redacteurGlobalId);
                    int id = SphereUtils.getId(redacteurGlobalId);
                    this.addAttribute("sphere", sphereKey.getSubsetName());
                    this.addAttribute("id", String.valueOf(id));
                    Redacteur redacteur = null;
                    Sphere sphere = (Sphere)this.extractionContext.getFichotheque().getSubset(sphereKey);
                    if (sphere != null) {
                        redacteur = sphere.getRedacteurById(id);
                    }
                    if (redacteur != null) {
                        this.addAttribute("login", redacteur.getLogin());
                        this.endOpenTag();
                        this.addPersonCore(redacteur.getPersonCore());
                        this.closeTag("personne");
                        break block7;
                    }
                    this.closeEmptyTag();
                }
                catch (ParseException pe) {
                    this.closeEmptyTag();
                }
            } else {
                this.endOpenTag();
                this.addPersonCore(personne.getPersonCore());
                this.addSimpleElement("organism", personne.getOrganism());
                if (this.extractVersion == 1) {
                    this.addSimpleElement("organisme", personne.getOrganism());
                }
                this.closeTag("personne");
            }
        }
    }

    private void addPersonCore(PersonCore personCore) throws IOException {
        String surname = personCore.getSurname();
        boolean surnameFirst = personCore.isSurnameFirst();
        if (surname.length() > 0) {
            this.startOpenTag("surname");
            if (surnameFirst) {
                this.addAttribute("surname-first", "true");
            }
            this.endOpenTag();
            this.addText(surname);
            this.closeTag("surname", false);
        }
        this.addSimpleElement("forename", personCore.getForename());
        this.addSimpleElement("nonlatin", personCore.getNonlatin());
        if (this.extractVersion == 1) {
            if (surname.length() > 0) {
                this.startOpenTag("nom");
                if (surnameFirst) {
                    this.addAttribute("avant", "true");
                }
                this.endOpenTag();
                this.addText(surname);
                this.closeTag("nom", false);
            }
            this.addSimpleElement("prenom", personCore.getForename());
            this.addSimpleElement("original", personCore.getNonlatin());
        }
    }

    public void addPara(Para para, IrefConverter irefConverter) throws IOException {
        this.startOpenTag("para");
        this.endOpenTag();
        this.ficheBlockXMLPart.addTextContent(para, irefConverter);
        this.closeTag("para", false);
    }
}

