/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.text.ParseException;
import java.util.AbstractList;
import java.util.List;
import java.util.RandomAccess;
import net.fichotheque.Fichotheque;
import net.fichotheque.SubsetKey;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.FicheAPI;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.fiche.Personne;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.sphere.LoginKey;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.models.PersonCore;
import net.mapeadores.util.models.PersonCoreUtils;

public final class SphereUtils {
    public static final short MALFORMED_KEY = 1;
    public static final short UNKNOWN_SPHERE = 2;
    public static final short UNKNOWN_LOGIN = 3;

    private SphereUtils() {
    }

    public static boolean testLogin(String login) {
        try {
            LoginKey.checkLogin(login);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static Redacteur getRedacteur(Fichotheque fichotheque, String redacteurGlobalId) {
        try {
            return (Redacteur)FichothequeUtils.parseGlobalId(redacteurGlobalId, fichotheque, (short)3, null);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static PersonCore toPersonCore(Fichotheque fichotheque, Personne personne) {
        String redacteurGlobalId = personne.getRedacteurGlobalId();
        if (redacteurGlobalId != null) {
            Redacteur redacteur = SphereUtils.getRedacteur(fichotheque, redacteurGlobalId);
            if (redacteur != null) {
                return redacteur.getPersonCore();
            }
            return PersonCoreUtils.toPersonCore(redacteurGlobalId, "", "", false);
        }
        return personne.getPersonCore();
    }

    public static boolean testRedacteurs(Corpus corpus, Redacteur redacteur) {
        String globalId = redacteur.getGlobalId();
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            if (!SphereUtils.ownsToRedacteur(ficheMeta, globalId)) continue;
            return true;
        }
        return false;
    }

    public static boolean testRedacteursAndFields(Corpus corpus, Redacteur redacteur, List<CorpusField> personneFieldList) {
        boolean redacTest = SphereUtils.testRedacteurs(corpus, redacteur);
        if (redacTest) {
            return true;
        }
        if (personneFieldList.isEmpty()) {
            return false;
        }
        FieldKey[] fieldKeyArray = CorpusMetadataUtils.toFieldKeyArray(personneFieldList);
        for (FicheMeta ficheMeta : corpus.getFicheMetaList()) {
            FicheAPI fiche = corpus.getFicheAPI(ficheMeta, false);
            block5: for (FieldKey fieldKey : fieldKeyArray) {
                Object value = fiche.getValue(fieldKey);
                if (value == null) continue;
                switch (fieldKey.getCategory()) {
                    case 1: {
                        boolean here = SphereUtils.testFicheItem(redacteur, (FicheItem)value);
                        if (!here) continue block5;
                        return true;
                    }
                    case 2: {
                        for (FicheItem ficheItem : (FicheItems)value) {
                            boolean here = SphereUtils.testFicheItem(redacteur, ficheItem);
                            if (!here) continue;
                            return true;
                        }
                        continue block5;
                    }
                }
            }
        }
        return false;
    }

    public static boolean testFicheItem(Redacteur redacteur, FicheItem ficheItem) {
        if (!(ficheItem instanceof Personne)) {
            return false;
        }
        String redacteurGlobalId = ((Personne)ficheItem).getRedacteurGlobalId();
        if (redacteurGlobalId != null) {
            return redacteurGlobalId.equals(redacteur.getGlobalId());
        }
        return false;
    }

    public static boolean testGlobalId(String redacteurGlobalId) {
        try {
            SphereUtils.getSubsetKey(redacteurGlobalId);
            SphereUtils.getId(redacteurGlobalId);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static SubsetKey getSubsetKey(String redacteurGlobalId) throws ParseException {
        int idx = redacteurGlobalId.indexOf(47);
        if (idx == -1) {
            throw new ParseException("Missing /", 0);
        }
        return SubsetKey.parse((short)3, redacteurGlobalId.substring(0, idx));
    }

    public static int getId(String redacteurGlobalId) throws ParseException {
        int idx = redacteurGlobalId.indexOf(47);
        if (idx == -1) {
            throw new ParseException("Missing /", 0);
        }
        try {
            int id = Integer.parseInt(redacteurGlobalId.substring(idx + 1));
            if (idx < 1) {
                throw new ParseException("Not positive integer", idx);
            }
            return id;
        }
        catch (NumberFormatException nfe) {
            throw new ParseException("Not integer", idx);
        }
    }

    public static boolean ownsToRedacteur(FicheMeta ficheMeta, Redacteur redacteur) {
        return SphereUtils.ownsToRedacteur(ficheMeta, redacteur.getGlobalId());
    }

    public static boolean ownsToRedacteur(FicheMeta ficheMeta, String redacteurGlobalId) {
        return ficheMeta.getRedacteurGlobalIdList().contains(redacteurGlobalId);
    }

    public static boolean ownsToSphere(FicheMeta ficheMeta, Sphere sphere) {
        return SphereUtils.ownsToSphere(ficheMeta, sphere.getSubsetName());
    }

    public static boolean ownsToSphere(FicheMeta ficheMeta, String sphereName) {
        List<String> globalIdList = ficheMeta.getRedacteurGlobalIdList();
        if (globalIdList.isEmpty()) {
            return false;
        }
        String prefix = sphereName + "/";
        for (String redacteurGlobalId : globalIdList) {
            if (!redacteurGlobalId.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public static Redacteur parse(Fichotheque fichotheque, String key) throws RedacteurLoginException {
        return SphereUtils.parse(fichotheque, key, null);
    }

    public static Redacteur parse(Fichotheque fichotheque, String key, @Nullable SubsetKey defaultSphereKey) throws RedacteurLoginException {
        try {
            LoginKey loginKey = LoginKey.parse(key);
            Sphere sphere = (Sphere)fichotheque.getSubset(loginKey.getSphereKey());
            if (sphere == null) {
                throw new RedacteurLoginException(2, "unknown sphere: " + loginKey.getSphereKey());
            }
            Redacteur redacteur = sphere.getRedacteurByLogin(loginKey.getLogin());
            if (redacteur == null) {
                throw new RedacteurLoginException(3, "unknown redacteur: " + loginKey.getLogin());
            }
            return redacteur;
        }
        catch (ParseException loginKey) {
            int idx = key.indexOf(47);
            if (idx != -1) {
                Redacteur redacteur = SphereUtils.getRedacteur(fichotheque, key);
                if (redacteur != null) {
                    return redacteur;
                }
                throw new RedacteurLoginException(1, "Wrong redacteurGlobalId");
            }
            if (defaultSphereKey == null) {
                throw new RedacteurLoginException(1, "Missing separator (_ or [])");
            }
            Sphere defaultSphere = (Sphere)fichotheque.getSubset(defaultSphereKey);
            if (defaultSphere == null) {
                throw new RedacteurLoginException(2, "unknown default sphere: " + defaultSphereKey);
            }
            Redacteur redacteur = defaultSphere.getRedacteurByLogin(key);
            if (redacteur == null) {
                throw new RedacteurLoginException(3, "unknown redacteur: " + key);
            }
            return redacteur;
        }
    }

    public static List<Redacteur> wrap(Redacteur[] array) {
        return new RedacteurList(array);
    }

    public static class RedacteurLoginException
    extends Exception {
        private final short type;

        private RedacteurLoginException(short type, String message) {
            super(message);
            this.type = type;
        }

        public short getType() {
            return this.type;
        }
    }

    private static class RedacteurList
    extends AbstractList<Redacteur>
    implements RandomAccess {
        private final Redacteur[] array;

        private RedacteurList(Redacteur[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Redacteur get(int index) {
            return this.array[index];
        }
    }
}

