/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.text.ParseException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.RandomAccess;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import net.fichotheque.Fichotheque;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.SubsetKey;
import net.fichotheque.addenda.Addenda;
import net.fichotheque.album.Album;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Datation;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.eligibility.SubsetEligibility;
import net.fichotheque.exportation.scrutari.CorpusScrutariDef;
import net.fichotheque.exportation.scrutari.ThesaurusScrutariDef;
import net.fichotheque.include.IncludeKey;
import net.fichotheque.namespaces.PhraseSpace;
import net.fichotheque.sphere.Sphere;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.utils.EligibilityUtils;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.attr.Attribute;
import net.mapeadores.util.attr.AttributeKey;
import net.mapeadores.util.attr.CheckedNameSpace;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.Label;
import net.mapeadores.util.text.Phrase;
import net.mapeadores.util.text.Phrases;
import net.mapeadores.util.text.StringUtils;

public final class FichothequeUtils {
    public static final List<SubsetItem> EMPTY_SUBSETITEMLIST = Collections.emptyList();
    public static final List<Corpus> EMPTY_CORPUSLIST = Collections.emptyList();
    public static final List<Thesaurus> EMPTY_THESAURUSLIST = Collections.emptyList();
    public static final List<SubsetKey> EMPTY_SUBSETKEYLIST = Collections.emptyList();
    public static final List<IncludeKey> EMPTY_INCLUDEKEYLIST = Collections.emptyList();
    public static final Set<SubsetKey> EMPTY_SUBSETKEYSET = Collections.emptySet();

    private FichothequeUtils() {
    }

    public static String toGlobalId(SubsetKey subsetKey, int id) {
        return subsetKey.getSubsetName() + "/" + id;
    }

    public static SubsetItem parseGlobalId(String globalId, Fichotheque fichotheque, short subsetCategory, @Nullable Subset defaultSubset) throws ParseException {
        int id;
        Subset subset;
        int idx = globalId.indexOf(47);
        if (idx == 0) {
            if (globalId.length() == 1) {
                throw new ParseException(globalId, 0);
            }
            idx = -1;
            globalId = globalId.substring(1);
        }
        if (idx == -1) {
            if (defaultSubset == null) {
                throw new ParseException(globalId, 0);
            }
            subset = defaultSubset;
            try {
                id = Integer.parseInt(globalId);
            }
            catch (NumberFormatException nfe) {
                throw new ParseException(globalId, 0);
            }
        }
        if (idx == globalId.length() - 1) {
            throw new ParseException(globalId, 0);
        }
        String subsetName = globalId.substring(0, idx);
        SubsetKey subsetKey = SubsetKey.parse(subsetCategory, subsetName);
        subset = fichotheque.getSubset(subsetKey);
        if (subset == null) {
            throw new ParseException(globalId, 0);
        }
        try {
            id = Integer.parseInt(globalId.substring(idx + 1));
        }
        catch (NumberFormatException nfe) {
            throw new ParseException(globalId, idx);
        }
        if (id < 0) {
            throw new ParseException(globalId, 0);
        }
        SubsetItem subsetItem = subset.getSubsetItemById(id);
        if (subsetItem == null) {
            throw new ParseException(globalId, 0);
        }
        return subsetItem;
    }

    public static boolean isValidPhraseName(String name) {
        try {
            CheckedNameSpace.parse(name);
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    public static void checkPhraseName(String name) throws ParseException {
        CheckedNameSpace.parse(name);
    }

    public static Datation getDatation(FicheMeta ficheMeta, String name) {
        FuzzyDate date = null;
        switch (name) {
            case "date_creation": {
                date = ficheMeta.getCreationDate();
                break;
            }
            case "date_modification": {
                date = ficheMeta.getModificationDate();
            }
        }
        if (date == null) {
            return null;
        }
        return new Datation(date);
    }

    @Nullable
    public static Label getTitleLabel(Subset subset, Lang lang) {
        return subset.getMetadata().getTitleLabels().getLangPartCheckedLabel(lang);
    }

    public static String getTitle(Subset subset, Lang lang) {
        Label label = FichothequeUtils.getTitleLabel(subset, lang);
        if (label != null) {
            return label.getLabelString();
        }
        return "[" + subset.getSubsetName() + "]";
    }

    public static String getTitleWithKey(Subset subset, Lang lang) {
        Label label = FichothequeUtils.getTitleLabel(subset, lang);
        if (label != null) {
            return label.getLabelString() + " [" + subset.getSubsetName() + "]";
        }
        return "[" + subset.getSubsetName() + "]";
    }

    public static String getTitle(Fichotheque fichotheque, SubsetKey subsetKey, Lang lang, boolean withKey) {
        Subset subset = fichotheque.getSubset(subsetKey);
        if (subset != null) {
            if (withKey) {
                return FichothequeUtils.getTitleWithKey(subset, lang);
            }
            return FichothequeUtils.getTitle(subset, lang);
        }
        return "[" + subsetKey.getSubsetName() + "]";
    }

    public static String getPhraseLabel(Phrases phrases, String name, Lang lang) {
        Label label;
        Phrase phrase = phrases.getPhrase(name);
        if (phrase != null && (label = phrase.getLangPartCheckedLabel(lang)) != null) {
            return label.getLabelString();
        }
        return null;
    }

    public static Thesaurus[] toThesaurusArray(Fichotheque fichotheque, Predicate<Subset> subsetAccessPredicate) {
        ArrayList<Thesaurus> thesaurusList = new ArrayList<Thesaurus>();
        for (Thesaurus thesaurus : fichotheque.getThesaurusList()) {
            if (!subsetAccessPredicate.test(thesaurus)) continue;
            thesaurusList.add(thesaurus);
        }
        return thesaurusList.toArray(new Thesaurus[thesaurusList.size()]);
    }

    public static Corpus[] toCorpusArray(Fichotheque fichotheque) {
        List<Corpus> corpusList = fichotheque.getCorpusList();
        return corpusList.toArray(new Corpus[corpusList.size()]);
    }

    public static Corpus[] toCorpusArray(Fichotheque fichotheque, Predicate<Subset> subsetAccessPredicate) {
        ArrayList<Corpus> corpusList = new ArrayList<Corpus>();
        for (Corpus corpus : fichotheque.getCorpusList()) {
            if (!subsetAccessPredicate.test(corpus)) continue;
            corpusList.add(corpus);
        }
        return corpusList.toArray(new Corpus[corpusList.size()]);
    }

    public static Addenda[] toAddendaArray(Fichotheque fichotheque) {
        List<Addenda> addendaList = fichotheque.getAddendaList();
        return addendaList.toArray(new Addenda[addendaList.size()]);
    }

    public static Addenda[] toAddendaArray(Fichotheque fichotheque, Predicate<Subset> subsetAccessPredicate) {
        ArrayList<Addenda> addendaList = new ArrayList<Addenda>();
        for (Addenda addenda : fichotheque.getAddendaList()) {
            if (!subsetAccessPredicate.test(addenda)) continue;
            addendaList.add(addenda);
        }
        return addendaList.toArray(new Addenda[addendaList.size()]);
    }

    public static Album[] toAlbumArray(Fichotheque fichotheque) {
        List<Album> albumList = fichotheque.getAlbumList();
        return albumList.toArray(new Album[albumList.size()]);
    }

    public static Album[] toAlbumArray(Fichotheque fichotheque, Predicate<Subset> subsetAccessPredicate) {
        ArrayList<Album> albumList = new ArrayList<Album>();
        for (Album album : fichotheque.getAlbumList()) {
            if (!subsetAccessPredicate.test(album)) continue;
            albumList.add(album);
        }
        return albumList.toArray(new Album[albumList.size()]);
    }

    public static Sphere[] toSphereArray(Fichotheque fichotheque) {
        List<Sphere> sphereList = fichotheque.getSphereList();
        return sphereList.toArray(new Sphere[sphereList.size()]);
    }

    public static Sphere[] toSphereArray(Fichotheque fichotheque, Predicate<Subset> subsetAccessPredicate) {
        ArrayList<Sphere> sphereList = new ArrayList<Sphere>();
        for (Sphere sphere : fichotheque.getSphereList()) {
            if (!subsetAccessPredicate.test(sphere)) continue;
            sphereList.add(sphere);
        }
        return sphereList.toArray(new Sphere[sphereList.size()]);
    }

    public static Subset[] toSubsetArray(Fichotheque fichotheque) {
        ArrayList<Subset> list = new ArrayList<Subset>();
        list.addAll(fichotheque.getCorpusList());
        list.addAll(fichotheque.getThesaurusList());
        list.addAll(fichotheque.getSphereList());
        list.addAll(fichotheque.getAddendaList());
        list.addAll(fichotheque.getAlbumList());
        return list.toArray(new Subset[list.size()]);
    }

    public static List<Subset> getSubsetList(Fichotheque fichotheque, short subsetCategory) {
        ArrayList<Subset> list = new ArrayList<Subset>();
        switch (subsetCategory) {
            case 1: {
                list.addAll(fichotheque.getCorpusList());
                break;
            }
            case 2: {
                list.addAll(fichotheque.getThesaurusList());
                break;
            }
            case 3: {
                list.addAll(fichotheque.getSphereList());
                break;
            }
            case 4: {
                list.addAll(fichotheque.getAddendaList());
                break;
            }
            case 5: {
                list.addAll(fichotheque.getAlbumList());
            }
        }
        return list;
    }

    public static Subset[] toSubsetArray(Fichotheque fichotheque, short subsetCategory) {
        List<Subset> list = FichothequeUtils.getSubsetList(fichotheque, subsetCategory);
        return list.toArray(new Subset[list.size()]);
    }

    public static Subset[] getSortedSubsetArray(Fichotheque fichotheque, SubsetEligibility subsetEligibility) {
        if (subsetEligibility == null) {
            subsetEligibility = EligibilityUtils.ALL_SUBSET_ELIGIBILITY;
        }
        TreeMap<SubsetKey, Subset> sortedMap = new TreeMap<SubsetKey, Subset>();
        for (Corpus corpus : fichotheque.getCorpusList()) {
            Subset masterSubset;
            if (!subsetEligibility.accept(corpus) || (masterSubset = corpus.getMasterSubset()) != null && !subsetEligibility.accept(masterSubset)) continue;
            sortedMap.put(corpus.getSubsetKey(), corpus);
        }
        for (Thesaurus thesaurus : fichotheque.getThesaurusList()) {
            if (!subsetEligibility.accept(thesaurus)) continue;
            sortedMap.put(thesaurus.getSubsetKey(), thesaurus);
        }
        for (Sphere sphere : fichotheque.getSphereList()) {
            if (!subsetEligibility.accept(sphere)) continue;
            sortedMap.put(sphere.getSubsetKey(), sphere);
        }
        for (Addenda addenda : fichotheque.getAddendaList()) {
            if (!subsetEligibility.accept(addenda)) continue;
            sortedMap.put(addenda.getSubsetKey(), addenda);
        }
        for (Album album : fichotheque.getAlbumList()) {
            if (!subsetEligibility.accept(album)) continue;
            sortedMap.put(album.getSubsetKey(), album);
        }
        return sortedMap.values().toArray(new Subset[sortedMap.size()]);
    }

    public static Corpus getCorpus(Fichotheque fichotheque, String corpusName) {
        try {
            SubsetKey subsetKey = SubsetKey.parse((short)1, corpusName);
            return (Corpus)fichotheque.getSubset(subsetKey);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Thesaurus getThesaurus(Fichotheque fichotheque, String thesaurusName) {
        try {
            SubsetKey subsetKey = SubsetKey.parse((short)2, thesaurusName);
            return (Thesaurus)fichotheque.getSubset(subsetKey);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Addenda getAddenda(Fichotheque fichotheque, String addendaName) {
        try {
            SubsetKey subsetKey = SubsetKey.parse((short)4, addendaName);
            return (Addenda)fichotheque.getSubset(subsetKey);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Album getAlbum(Fichotheque fichotheque, String thesaurusName) {
        try {
            SubsetKey subsetKey = SubsetKey.parse((short)5, thesaurusName);
            return (Album)fichotheque.getSubset(subsetKey);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Sphere getSphere(Fichotheque fichotheque, String sphereName) {
        try {
            SubsetKey subsetKey = SubsetKey.parse((short)3, sphereName);
            return (Sphere)fichotheque.getSubset(subsetKey);
        }
        catch (ParseException pe) {
            return null;
        }
    }

    public static Set<SubsetKey> toSubsetKeySet(short category, String s) {
        String[] tokens = StringUtils.getTechnicalTokens(s, true);
        if (tokens.length == 0) {
            return EMPTY_SUBSETKEYSET;
        }
        LinkedHashSet<SubsetKey> result = new LinkedHashSet<SubsetKey>();
        for (String token : tokens) {
            try {
                SubsetKey subsetKey = SubsetKey.parse(category, token);
                result.add(subsetKey);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return result;
    }

    public static Collection<SubsetItem> filterAndSort(Subset subset, Predicate<SubsetItem> predicate) {
        TreeMap<Integer, SubsetItem> sortedMap = new TreeMap<Integer, SubsetItem>();
        for (SubsetItem subsetItem : subset.getSubsetItemList()) {
            if (!predicate.test(subsetItem)) continue;
            sortedMap.put(subsetItem.getId(), subsetItem);
        }
        return sortedMap.values();
    }

    public static boolean ownToSameParentage(Subset subset1, Subset subset2) {
        if (subset1 instanceof Corpus) {
            return FichothequeUtils.isParentageCorpus((Corpus)subset1, subset2);
        }
        if (subset2 instanceof Corpus) {
            return FichothequeUtils.isParentageCorpus((Corpus)subset2, subset1);
        }
        return false;
    }

    public static boolean isParentageCorpus(Corpus corpus, Subset subset) {
        Subset masterSubset = corpus.getMasterSubset();
        if (masterSubset != null) {
            if (masterSubset.equals(subset)) {
                return true;
            }
            if (subset instanceof Corpus) {
                Subset otherMaster = ((Corpus)subset).getMasterSubset();
                return otherMaster != null && otherMaster.equals(masterSubset);
            }
            return false;
        }
        if (subset instanceof Corpus) {
            Subset otherMaster = ((Corpus)subset).getMasterSubset();
            return otherMaster != null && otherMaster.equals(corpus);
        }
        return false;
    }

    public static List<Corpus> getParentageCorpusList(Corpus corpus) {
        Subset masterSubset = corpus.getMasterSubset();
        if (masterSubset == null) {
            return corpus.getSatelliteCorpusList();
        }
        List<Corpus> satelliteList = masterSubset.getSatelliteCorpusList();
        ArrayList<Corpus> result = new ArrayList<Corpus>();
        if (masterSubset instanceof Corpus) {
            result.add((Corpus)masterSubset);
        }
        if (satelliteList.size() > 1) {
            for (Corpus other : satelliteList) {
                if (other.equals(corpus)) continue;
                result.add(other);
            }
        }
        return result;
    }

    public static Object parseKey(String key) {
        try {
            FieldKey fieldKey = FieldKey.parse(key);
            return fieldKey;
        }
        catch (ParseException pe) {
            try {
                IncludeKey includeKey = IncludeKey.parse(key);
                return includeKey;
            }
            catch (ParseException pe2) {
                return null;
            }
        }
    }

    public static String getNumberPhrase(SubsetItem subsetItem, String phraseName, Lang workingLang, Locale formatLocale) {
        return FichothequeUtils.getNumberPhrase(subsetItem.getSubset(), subsetItem.getId(), phraseName, workingLang, formatLocale, null);
    }

    public static String getNumberPhrase(SubsetItem subsetItem, String phraseName, Lang workingLang, Locale formatLocale, String defaultString) {
        return FichothequeUtils.getNumberPhrase(subsetItem.getSubset(), subsetItem.getId(), phraseName, workingLang, formatLocale, defaultString);
    }

    public static String getNumberPhrase(Subset subset, int id, String phraseName, Lang workingLang, Locale formatLocale, String defaultString) {
        Label label;
        Phrase phrase;
        if (formatLocale == null) {
            formatLocale = workingLang.toLocale();
        }
        if ((phrase = subset.getMetadata().getPhrases().getPhrase(phraseName)) != null && (label = phrase.getLabel(workingLang)) != null) {
            String labelString = label.getLabelString();
            if (FichothequeUtils.appendNumber(subset, phraseName)) {
                String numberString = StringUtils.toString(id, formatLocale);
                if (labelString.length() > 0 && Character.isLetter(labelString.charAt(labelString.length() - 1))) {
                    return labelString + " " + numberString;
                }
                return labelString + numberString;
            }
            return labelString;
        }
        if (defaultString != null) {
            return defaultString;
        }
        return subset.getSubsetName() + "/" + id;
    }

    public static List<SubsetItem> wrap(SubsetItem[] array) {
        return new SubsetItemList(array);
    }

    public static List<CorpusScrutariDef> wrap(CorpusScrutariDef[] array) {
        return new CorpusScrutariDefList(array);
    }

    public static List<ThesaurusScrutariDef> wrap(ThesaurusScrutariDef[] array) {
        return new ThesaurusScrutariDefList(array);
    }

    public static List<SubsetKey> wrap(SubsetKey[] array) {
        return new SubsetKeyList(array);
    }

    public static List<SubsetKey> toList(Collection<SubsetKey> collection) {
        int size = collection.size();
        if (size == 0) {
            return EMPTY_SUBSETKEYLIST;
        }
        return new SubsetKeyList(collection.toArray(new SubsetKey[size]));
    }

    public static List<IncludeKey> wrap(IncludeKey[] array) {
        return new IncludeKeyList(array);
    }

    public static List<Addenda> wrap(Addenda[] array) {
        return new AddendaList(array);
    }

    public static List<Album> wrap(Album[] array) {
        return new AlbumList(array);
    }

    public static List<Corpus> wrap(Corpus[] array) {
        return new CorpusList(array);
    }

    public static List<Thesaurus> wrap(Thesaurus[] array) {
        return new ThesaurusList(array);
    }

    public static List<Sphere> wrap(Sphere[] array) {
        return new SphereList(array);
    }

    private static boolean appendNumber(Subset subset, String phraseName) {
        AttributeKey attributeKey = PhraseSpace.getNumberAttributeKey(phraseName);
        if (attributeKey == null) {
            return false;
        }
        Attribute attribute = subset.getMetadata().getAttributes().getAttribute(attributeKey);
        if (attribute == null) {
            return true;
        }
        return !attribute.getFirstValue().equals("ignore");
    }

    private static class SubsetItemList
    extends AbstractList<SubsetItem>
    implements RandomAccess {
        private final SubsetItem[] array;

        private SubsetItemList(SubsetItem[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SubsetItem get(int index) {
            return this.array[index];
        }
    }

    private static class CorpusScrutariDefList
    extends AbstractList<CorpusScrutariDef>
    implements RandomAccess {
        private final CorpusScrutariDef[] array;

        private CorpusScrutariDefList(CorpusScrutariDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public CorpusScrutariDef get(int index) {
            return this.array[index];
        }
    }

    private static class ThesaurusScrutariDefList
    extends AbstractList<ThesaurusScrutariDef>
    implements RandomAccess {
        private final ThesaurusScrutariDef[] array;

        private ThesaurusScrutariDefList(ThesaurusScrutariDef[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public ThesaurusScrutariDef get(int index) {
            return this.array[index];
        }
    }

    private static class SubsetKeyList
    extends AbstractList<SubsetKey>
    implements RandomAccess {
        private final SubsetKey[] array;

        private SubsetKeyList(SubsetKey[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public SubsetKey get(int index) {
            return this.array[index];
        }
    }

    private static class IncludeKeyList
    extends AbstractList<IncludeKey>
    implements RandomAccess {
        private final IncludeKey[] array;

        private IncludeKeyList(IncludeKey[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public IncludeKey get(int index) {
            return this.array[index];
        }
    }

    private static class AddendaList
    extends AbstractList<Addenda>
    implements RandomAccess {
        private final Addenda[] array;

        private AddendaList(Addenda[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Addenda get(int index) {
            return this.array[index];
        }
    }

    private static class AlbumList
    extends AbstractList<Album>
    implements RandomAccess {
        private final Album[] array;

        private AlbumList(Album[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Album get(int index) {
            return this.array[index];
        }
    }

    private static class CorpusList
    extends AbstractList<Corpus>
    implements RandomAccess {
        private final Corpus[] array;

        private CorpusList(Corpus[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Corpus get(int index) {
            return this.array[index];
        }
    }

    private static class ThesaurusList
    extends AbstractList<Thesaurus>
    implements RandomAccess {
        private final Thesaurus[] array;

        private ThesaurusList(Thesaurus[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Thesaurus get(int index) {
            return this.array[index];
        }
    }

    private static class SphereList
    extends AbstractList<Sphere>
    implements RandomAccess {
        private final Sphere[] array;

        private SphereList(Sphere[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public Sphere get(int index) {
            return this.array[index];
        }
    }
}

