/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.util.AbstractList;
import java.util.Collection;
import java.util.RandomAccess;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.AttConsumer;
import net.fichotheque.corpus.fiche.Atts;
import net.fichotheque.corpus.fiche.FicheBlock;
import net.fichotheque.corpus.fiche.FicheBlocks;
import net.fichotheque.corpus.fiche.FicheItem;
import net.fichotheque.corpus.fiche.FicheItems;
import net.fichotheque.corpus.metadata.FieldKey;
import net.mapeadores.util.annotation.Nullable;

public final class FicheUtils {
    public static final FicheItems EMPTY_FICHEITEMS = new EmptyFicheItems();
    public static final FicheBlocks EMPTY_FICHEBLOCKS = new EmptyFicheBlocks();

    private FicheUtils() {
    }

    public static Object getValue(FicheMeta ficheMeta, FieldKey fieldKey) {
        if (fieldKey.isSection()) {
            return ficheMeta.getFicheAPI(true).getValue(fieldKey);
        }
        switch (fieldKey.getKeyString()) {
            case "id": {
                return ficheMeta.getId();
            }
            case "titre": {
                String titre = ficheMeta.getTitre();
                if (titre.isEmpty()) {
                    return null;
                }
                return titre;
            }
        }
        return ficheMeta.getFicheAPI(false).getValue(fieldKey);
    }

    public static FicheItems toFicheItems(FicheItem ficheItem) {
        if (ficheItem == null) {
            return EMPTY_FICHEITEMS;
        }
        return new SingletonFicheItems(ficheItem);
    }

    public static FicheItems toFicheItems(Collection<FicheItem> ficheItemCollection) {
        int size = ficheItemCollection.size();
        if (size == 0) {
            return EMPTY_FICHEITEMS;
        }
        FicheItem[] array = ficheItemCollection.toArray(new FicheItem[size]);
        if (size == 1) {
            return new SingletonFicheItems(array[0]);
        }
        return new ArrayFicheItems(array);
    }

    public static FicheBlocks toFicheBlocks(FicheBlock ficheBlock) {
        if (ficheBlock == null) {
            return EMPTY_FICHEBLOCKS;
        }
        return new SingletonFicheBlocks(ficheBlock);
    }

    public static FicheBlocks toFicheBlocks(Collection<FicheBlock> ficheBlockCollection) {
        int size = ficheBlockCollection.size();
        if (size == 0) {
            return EMPTY_FICHEBLOCKS;
        }
        FicheBlock[] array = ficheBlockCollection.toArray(new FicheBlock[size]);
        if (size == 1) {
            return new SingletonFicheBlocks(array[0]);
        }
        return new ArrayFicheBlocks(array);
    }

    public static void populate(AttConsumer attConsumer, @Nullable Atts atts) {
        if (atts != null) {
            int attLength = atts.size();
            for (int i = 0; i < attLength; ++i) {
                attConsumer.putAtt(atts.getName(i), atts.getValue(i));
            }
        }
    }

    private static class SingletonFicheItems
    extends AbstractList<FicheItem>
    implements FicheItems,
    RandomAccess {
        private final FicheItem ficheItem;

        private SingletonFicheItems(FicheItem ficheItem) {
            this.ficheItem = ficheItem;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public FicheItem get(int index) {
            if (index == 0) {
                return this.ficheItem;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    private static class ArrayFicheItems
    extends AbstractList<FicheItem>
    implements FicheItems,
    RandomAccess {
        private final FicheItem[] ficheItemArray;

        private ArrayFicheItems(FicheItem[] ficheItemArray) {
            this.ficheItemArray = ficheItemArray;
        }

        @Override
        public int size() {
            return this.ficheItemArray.length;
        }

        @Override
        public FicheItem get(int index) {
            return this.ficheItemArray[index];
        }
    }

    private static class SingletonFicheBlocks
    extends AbstractList<FicheBlock>
    implements FicheBlocks {
        private final FicheBlock ficheBlock;

        private SingletonFicheBlocks(FicheBlock ficheBlock) {
            this.ficheBlock = ficheBlock;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public FicheBlock get(int index) {
            if (index == 0) {
                return this.ficheBlock;
            }
            throw new IndexOutOfBoundsException();
        }
    }

    private static class ArrayFicheBlocks
    extends AbstractList<FicheBlock>
    implements FicheBlocks {
        private final FicheBlock[] array;

        private ArrayFicheBlocks(FicheBlock[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public FicheBlock get(int index) {
            return this.array[index];
        }
    }

    private static class EmptyFicheItems
    extends AbstractList<FicheItem>
    implements FicheItems,
    RandomAccess {
        private EmptyFicheItems() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public FicheItem get(int index) {
            throw new IndexOutOfBoundsException();
        }
    }

    private static class EmptyFicheBlocks
    extends AbstractList<FicheBlock>
    implements FicheBlocks {
        private EmptyFicheBlocks() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public FicheBlock get(int index) {
            throw new IndexOutOfBoundsException();
        }
    }
}

