/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.RandomAccess;
import java.util.Set;
import java.util.function.Predicate;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldGeneration;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.utils.FichothequeUtils;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.money.Currencies;
import net.mapeadores.util.text.Label;

public final class CorpusMetadataUtils {
    public static final List<FieldKey> EMPTY_FIELDKEYLIST = Collections.emptyList();
    public static final List<CorpusField> EMPTY_CORPUSFIELDLIST = Collections.emptyList();
    public static final FieldGeneration EMPTY_FIELDGENERATION = new EmptyFieldGeneration();

    private CorpusMetadataUtils() {
    }

    public static String getDefaultLangScope(FieldKey fieldKey) {
        switch (fieldKey.getKeyString()) {
            case "lang": {
                return "config";
            }
        }
        return "all";
    }

    public static boolean isCurrenciesPropriete(CorpusField corpusField) {
        if (!corpusField.isPropriete()) {
            return false;
        }
        Currencies currencies = corpusField.getCurrencies();
        return currencies != null;
    }

    public static boolean isCurrenciesInformation(CorpusField corpusField) {
        if (!corpusField.isInformation()) {
            return false;
        }
        Currencies currencies = corpusField.getCurrencies();
        return currencies != null;
    }

    public static String getFieldTitle(CorpusField corpusField, Lang lang) {
        return CorpusMetadataUtils.getFieldTitle(corpusField, lang, false);
    }

    public static String getFieldTitle(CorpusField corpusField, Lang lang, boolean withKey) {
        Label label = corpusField.getLabels().getLangPartCheckedLabel(lang);
        if (label == null) {
            if (withKey) {
                return "[" + corpusField.getFieldString() + "]";
            }
            return corpusField.getFieldString();
        }
        if (withKey) {
            return "[" + corpusField.getFieldString() + "] " + label.getLabelString();
        }
        return label.getLabelString();
    }

    public static String getNewFicheLabel(Corpus corpus, Lang lang) {
        String label = FichothequeUtils.getPhraseLabel(corpus.getCorpusMetadata().getPhrases(), "newfiche", lang);
        if (label != null) {
            return label;
        }
        return corpus.getSubsetName();
    }

    public static String getSatelliteLabel(Corpus corpus, Lang lang) {
        String label = FichothequeUtils.getPhraseLabel(corpus.getCorpusMetadata().getPhrases(), "satellite", lang);
        if (label != null) {
            return label;
        }
        return FichothequeUtils.getTitle(corpus, lang);
    }

    public static String getFicheTitle(FicheMeta ficheMeta, Lang workingLang, Locale formatLocale) {
        return FichothequeUtils.getNumberPhrase(ficheMeta, "fiche", workingLang, formatLocale) + " \u2013 " + ficheMeta.getTitre();
    }

    public static List<CorpusField> getCorpusFieldList(CorpusMetadata corpusMetadata) {
        List<CorpusField> list = CorpusMetadataUtils.getSpecialCorpusFieldList(corpusMetadata, true);
        list.addAll(corpusMetadata.getProprieteList());
        list.addAll(corpusMetadata.getInformationList());
        list.addAll(corpusMetadata.getSectionList());
        return list;
    }

    public static List<CorpusField> getSpecialCorpusFieldList(CorpusMetadata corpusMetadata, boolean withId) {
        ArrayList<CorpusField> list = new ArrayList<CorpusField>();
        if (withId) {
            list.add(corpusMetadata.getCorpusField(FieldKey.ID));
        }
        list.add(corpusMetadata.getCorpusField(FieldKey.LANG));
        list.add(corpusMetadata.getCorpusField(FieldKey.TITRE));
        list.add(corpusMetadata.getCorpusField(FieldKey.REDACTEURS));
        CorpusField soustitre = corpusMetadata.getCorpusField(FieldKey.SOUSTITRE);
        if (soustitre != null) {
            list.add(soustitre);
        }
        return list;
    }

    public static Predicate<FieldKey> getFieldKeyPredicate(CorpusMetadata corpusMetadata) {
        HashSet<FieldKey> currentSet = new HashSet<FieldKey>();
        currentSet.add(FieldKey.ID);
        currentSet.add(FieldKey.LANG);
        currentSet.add(FieldKey.TITRE);
        currentSet.add(FieldKey.REDACTEURS);
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            currentSet.add(corpusField.getFieldKey());
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            currentSet.add(corpusField.getFieldKey());
        }
        for (CorpusField corpusField : corpusMetadata.getSectionList()) {
            currentSet.add(corpusField.getFieldKey());
        }
        if (corpusMetadata.isWithSoustitre()) {
            currentSet.add(FieldKey.SOUSTITRE);
        }
        return new SetPredicate(currentSet);
    }

    public static boolean containsRemoveableField(CorpusMetadata corpusMetadata) {
        if (corpusMetadata.isWithSoustitre()) {
            return true;
        }
        if (!corpusMetadata.getProprieteList().isEmpty()) {
            return true;
        }
        if (!corpusMetadata.getInformationList().isEmpty()) {
            return true;
        }
        return !corpusMetadata.getSectionList().isEmpty();
    }

    public static String ficheItemTypeToString(short ficheItemType) {
        switch (ficheItemType) {
            case 2: {
                return "personne";
            }
            case 3: {
                return "langue";
            }
            case 5: {
                return "datation";
            }
            case 4: {
                return "pays";
            }
            case 6: {
                return "courriel";
            }
            case 7: {
                return "link";
            }
            case 1: {
                return "item";
            }
            case 8: {
                return "nombre";
            }
            case 9: {
                return "montant";
            }
            case 10: {
                return "geopoint";
            }
            case 11: {
                return "para";
            }
            case 12: {
                return "image";
            }
        }
        return "";
    }

    public static List<CorpusField> getCorpusFieldListByFicheItemType(CorpusMetadata corpusMetadata, short ficheItemType, boolean startWithSpecial) {
        ArrayList<CorpusField> liste = new ArrayList<CorpusField>();
        if (startWithSpecial) {
            if (ficheItemType == 2) {
                liste.add(corpusMetadata.getCorpusField(FieldKey.REDACTEURS));
            }
            if (ficheItemType == 3) {
                liste.add(corpusMetadata.getCorpusField(FieldKey.LANG));
            }
        }
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            if (corpusField.getFicheItemType() != ficheItemType) continue;
            liste.add(corpusField);
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            if (corpusField.getFicheItemType() != ficheItemType) continue;
            liste.add(corpusField);
        }
        return liste;
    }

    public static FieldKey[] getEnteteFieldKeyArray(CorpusMetadata corpusMetadata) {
        ArrayList<FieldKey> fieldKeyList = new ArrayList<FieldKey>();
        fieldKeyList.add(FieldKey.TITRE);
        fieldKeyList.add(FieldKey.LANG);
        fieldKeyList.add(FieldKey.REDACTEURS);
        if (corpusMetadata.isWithSoustitre()) {
            fieldKeyList.add(FieldKey.SOUSTITRE);
        }
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            fieldKeyList.add(corpusField.getFieldKey());
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            fieldKeyList.add(corpusField.getFieldKey());
        }
        return fieldKeyList.toArray(new FieldKey[fieldKeyList.size()]);
    }

    public static FieldKey[] getFicheFieldKeyArray(CorpusMetadata corpusMetadata) {
        ArrayList<FieldKey> fieldKeyList = new ArrayList<FieldKey>();
        fieldKeyList.add(FieldKey.TITRE);
        fieldKeyList.add(FieldKey.LANG);
        fieldKeyList.add(FieldKey.REDACTEURS);
        if (corpusMetadata.isWithSoustitre()) {
            fieldKeyList.add(FieldKey.SOUSTITRE);
        }
        for (CorpusField corpusField : corpusMetadata.getProprieteList()) {
            fieldKeyList.add(corpusField.getFieldKey());
        }
        for (CorpusField corpusField : corpusMetadata.getInformationList()) {
            fieldKeyList.add(corpusField.getFieldKey());
        }
        for (CorpusField corpusField : corpusMetadata.getSectionList()) {
            fieldKeyList.add(corpusField.getFieldKey());
        }
        return fieldKeyList.toArray(new FieldKey[fieldKeyList.size()]);
    }

    public static FieldKey[] toFieldKeyArray(List<CorpusField> corpusFieldList) {
        int length = corpusFieldList.size();
        FieldKey[] result = new FieldKey[length];
        for (int i = 0; i < length; ++i) {
            result[i] = corpusFieldList.get(i).getFieldKey();
        }
        return result;
    }

    public static boolean areEquals(List<CorpusField> corpusFieldList, List<CorpusField> list) {
        int length = list.size();
        if (length != corpusFieldList.size()) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        for (int i = 0; i < length; ++i) {
            if (list.get(i).equals(corpusFieldList.get(i))) continue;
            return false;
        }
        return true;
    }

    public static List<CorpusField> removeCorpusField(List<CorpusField> corpusFieldList, CorpusField corpusField) {
        if (corpusFieldList == null) {
            return null;
        }
        ArrayList<CorpusField> result = new ArrayList<CorpusField>();
        boolean done = false;
        for (CorpusField otherCorpusField : corpusFieldList) {
            if (otherCorpusField.equals(corpusField)) {
                done = true;
                continue;
            }
            result.add(otherCorpusField);
        }
        if (!done) {
            return corpusFieldList;
        }
        int size = result.size();
        if (result.isEmpty()) {
            return null;
        }
        return CorpusMetadataUtils.wrap(result.toArray(new CorpusField[size]));
    }

    public static List<FieldKey> wrap(FieldKey[] array) {
        return new FieldKeyList(array);
    }

    public static List<CorpusField> wrap(CorpusField[] array) {
        return new CorpusFieldList(array);
    }

    private static class SetPredicate
    implements Predicate<FieldKey> {
        private final Set<FieldKey> set;

        private SetPredicate(Set<FieldKey> set) {
            this.set = set;
        }

        @Override
        public boolean test(FieldKey fieldKey) {
            return this.set.contains(fieldKey);
        }
    }

    private static class FieldKeyList
    extends AbstractList<FieldKey>
    implements RandomAccess {
        private final FieldKey[] array;

        private FieldKeyList(FieldKey[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public FieldKey get(int index) {
            return this.array[index];
        }
    }

    private static class CorpusFieldList
    extends AbstractList<CorpusField>
    implements RandomAccess {
        private final CorpusField[] array;

        private CorpusFieldList(CorpusField[] array) {
            this.array = array;
        }

        @Override
        public int size() {
            return this.array.length;
        }

        @Override
        public CorpusField get(int index) {
            return this.array[index];
        }
    }

    private static class EmptyFieldGeneration
    implements FieldGeneration {
        private final List<FieldGeneration.Entry> list = Collections.emptyList();

        private EmptyFieldGeneration() {
        }

        @Override
        public String getRawString() {
            return "";
        }

        @Override
        public List<FieldGeneration.Entry> getEntryList() {
            return this.list;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    }
}

