/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.utils;

import java.text.Collator;
import java.util.Comparator;
import net.fichotheque.Subset;
import net.fichotheque.SubsetItem;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.croisement.Liaison;
import net.fichotheque.externalsource.ExternalItem;
import net.fichotheque.sphere.Redacteur;
import net.fichotheque.thesaurus.Motcle;
import net.mapeadores.util.annotation.Nullable;
import net.mapeadores.util.exceptions.SwitchException;
import net.mapeadores.util.localisation.Lang;
import net.mapeadores.util.primitives.FuzzyDate;
import net.mapeadores.util.text.Label;

public final class Comparators {
    public static final Comparator<Motcle> IDALPHA = new IdalphaComparator(false);
    public static final Comparator<Motcle> MOTCLEID_ASC = new MotcleIdComparator(false);
    public static final Comparator<Motcle> MOTCLEID_DESC = new MotcleIdComparator(true);
    public static final Comparator<FicheMeta> FICHEID_ASC = new FicheIdComparator(false);
    public static final Comparator<FicheMeta> FICHEID_DESC = new FicheIdComparator(true);
    public static final Comparator<FicheMeta> CREATIONDATE_ASC = new CreationDateComparator(false);
    public static final Comparator<FicheMeta> CREATIONDATE_DESC = new CreationDateComparator(true);
    public static final Comparator<FicheMeta> MODIFICATIONDATE_ASC = new ModificationDateComparator(false);
    public static final Comparator<FicheMeta> MODIFICATIONDATE_DESC = new ModificationDateComparator(true);
    public static final Comparator<Liaison> LIAISONID = new LiaisonIdComparator();
    public static final Comparator<FieldKey> FIELDKEY = new FieldKeyComparator();
    public static final Comparator<Subset> SIZE = new SizeComparator();
    public static final Comparator<Redacteur> REDACTEUR = new RedacteurComparator();
    public static final Comparator<ExternalItem> EXTERNALITEMID_ASC = new ExternalItemIdComparator(false);
    public static final Comparator<ExternalItem> EXTERNALITEMID_DESC = new ExternalItemIdComparator(true);

    private Comparators() {
    }

    public static Comparator<FicheMeta> titre(Collator collator, boolean desc) {
        return new TitreComparator(collator, desc);
    }

    public static Comparator<Motcle> label(Lang lang) {
        Collator collator = Collator.getInstance(lang.toLocale());
        collator.setStrength(0);
        return new LabelComparator(lang, collator);
    }

    public static Comparator<Motcle> label(Lang lang, Collator collator) {
        return new LabelComparator(lang, collator);
    }

    public static Comparator<Motcle> idalphaAndLabel(Lang lang) {
        return new IdalphaAndLabelComparator(lang);
    }

    public static boolean needCollator(String sortType) {
        switch (sortType) {
            case "titre-asc": 
            case "titre-desc": {
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static Comparator<FicheMeta> getComparator(String sortType, @Nullable Lang sortLang) {
        Collator collator = null;
        if (Comparators.needCollator(sortType)) {
            if (sortLang == null) {
                throw new IllegalArgumentException("lang is null");
            }
            collator = Collator.getInstance(sortLang.toLocale());
            collator.setStrength(0);
        }
        return Comparators.getComparator(sortType, collator);
    }

    @Nullable
    public static Comparator<FicheMeta> getComparator(String sortType, @Nullable Collator collator) {
        switch (sortType) {
            case "titre-asc": {
                if (collator == null) {
                    throw new IllegalArgumentException("collator is null");
                }
                return Comparators.titre(collator, false);
            }
            case "titre-desc": {
                if (collator == null) {
                    throw new IllegalArgumentException("collator is null");
                }
                return Comparators.titre(collator, true);
            }
            case "creationdate-asc": {
                return CREATIONDATE_ASC;
            }
            case "creationdate-desc": {
                return CREATIONDATE_DESC;
            }
            case "modificationdate-asc": {
                return MODIFICATIONDATE_ASC;
            }
            case "modificationdate-desc": {
                return MODIFICATIONDATE_DESC;
            }
            case "id-asc": {
                return FICHEID_ASC;
            }
            case "id-desc": {
                return FICHEID_DESC;
            }
            case "none": {
                return null;
            }
        }
        throw new SwitchException("sortType=" + sortType);
    }

    private static int compareId(SubsetItem piece1, SubsetItem piece2) {
        int id2;
        int result = piece1.getSubsetKey().compareTo(piece2.getSubsetKey());
        if (result != 0) {
            return result;
        }
        int id1 = piece1.getId();
        if (id1 < (id2 = piece2.getId())) {
            return -1;
        }
        if (id1 > id2) {
            return 1;
        }
        return 0;
    }

    private static int getWeight(FieldKey fieldKey) {
        switch (fieldKey.getCategory()) {
            case 1: {
                return 30;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 10;
            }
            case 0: {
                switch (fieldKey.getKeyString()) {
                    case "id": {
                        return 150;
                    }
                    case "titre": {
                        return 140;
                    }
                    case "soustitre": {
                        return 130;
                    }
                    case "lang": {
                        return 120;
                    }
                    case "redacteurs": {
                        return 110;
                    }
                }
                throw new SwitchException("Unknown special field = " + fieldKey.getKeyString());
            }
        }
        throw new SwitchException("Unknown category = " + fieldKey.getCategory());
    }

    private static class TitreComparator
    implements Comparator<FicheMeta> {
        private final Collator collator;
        private final boolean desc;

        private TitreComparator(Collator collator, boolean desc) {
            this.collator = collator;
            this.desc = desc;
        }

        @Override
        public int compare(FicheMeta ficheMeta1, FicheMeta ficheMeta2) {
            int result = this.collator.compare(ficheMeta1.getTitre(), ficheMeta2.getTitre());
            if (result == 0) {
                result = Comparators.compareId(ficheMeta1, ficheMeta2);
            }
            if (this.desc) {
                return -result;
            }
            return result;
        }
    }

    private static class LabelComparator
    implements Comparator<Motcle> {
        private final Lang lang;
        private final Collator collator;

        public LabelComparator(Lang lang, Collator collator) {
            this.lang = lang;
            this.collator = collator;
        }

        @Override
        public int compare(Motcle motcle1, Motcle motcle2) {
            int result = this.collator.compare(this.toComparableString(motcle1), this.toComparableString(motcle2));
            if (result == 0) {
                result = Comparators.compareId(motcle1, motcle2);
            }
            return result;
        }

        private String toComparableString(Motcle motcle) {
            Label label = motcle.getLabels().getLabel(this.lang);
            if (label != null) {
                return label.getLabelString();
            }
            return "";
        }
    }

    private static class IdalphaAndLabelComparator
    implements Comparator<Motcle> {
        private final Lang lang;

        public IdalphaAndLabelComparator(Lang lang) {
            this.lang = lang;
        }

        @Override
        public int compare(Motcle mc1, Motcle mc2) {
            int id2;
            String lib2;
            String lib1 = this.toComparableString(mc1);
            int result = lib1.compareTo(lib2 = this.toComparableString(mc2));
            if (result != 0) {
                return result;
            }
            result = mc1.getSubsetKey().compareTo(mc2.getSubsetKey());
            if (result != 0) {
                return result;
            }
            int id1 = mc1.getId();
            if (id1 < (id2 = mc2.getId())) {
                return -1;
            }
            if (id1 > id2) {
                return 1;
            }
            return 0;
        }

        private String toComparableString(Motcle motcle) {
            String idalpha = motcle.getIdalpha();
            Label label = motcle.getLabels().getLabel(this.lang);
            if (idalpha != null) {
                if (label != null) {
                    return idalpha + " \u2013 " + label.getLabelString();
                }
                return idalpha;
            }
            if (label != null) {
                return label.getLabelString();
            }
            return "";
        }
    }

    private static class IdalphaComparator
    implements Comparator<Motcle> {
        private final boolean desc;

        private IdalphaComparator(boolean desc) {
            this.desc = desc;
        }

        @Override
        public int compare(Motcle motcle1, Motcle motcle2) {
            String idalpha1 = motcle1.getIdalpha();
            String idalpha2 = motcle2.getIdalpha();
            int result = idalpha1.compareTo(idalpha2);
            if (this.desc) {
                return -result;
            }
            return result;
        }
    }

    private static class MotcleIdComparator
    implements Comparator<Motcle> {
        private final boolean desc;

        private MotcleIdComparator(boolean desc) {
            this.desc = desc;
        }

        @Override
        public int compare(Motcle motcle1, Motcle motcle2) {
            int result = Comparators.compareId(motcle1, motcle2);
            if (this.desc) {
                return -result;
            }
            return result;
        }
    }

    private static class FicheIdComparator
    implements Comparator<FicheMeta> {
        private final boolean desc;

        private FicheIdComparator(boolean desc) {
            this.desc = desc;
        }

        @Override
        public int compare(FicheMeta ficheMeta1, FicheMeta ficheMeta2) {
            int result = Comparators.compareId(ficheMeta1, ficheMeta2);
            if (this.desc) {
                return -result;
            }
            return result;
        }
    }

    private static class CreationDateComparator
    implements Comparator<FicheMeta> {
        private final boolean desc;

        private CreationDateComparator(boolean desc) {
            this.desc = desc;
        }

        @Override
        public int compare(FicheMeta ficheMeta1, FicheMeta ficheMeta2) {
            int result = FuzzyDate.compare(ficheMeta1.getCreationDate(), ficheMeta2.getCreationDate());
            if (result == 0) {
                result = Comparators.compareId(ficheMeta1, ficheMeta2);
            }
            if (this.desc) {
                return -result;
            }
            return result;
        }
    }

    private static class ModificationDateComparator
    implements Comparator<FicheMeta> {
        private final boolean desc;

        private ModificationDateComparator(boolean desc) {
            this.desc = desc;
        }

        @Override
        public int compare(FicheMeta ficheMeta1, FicheMeta ficheMeta2) {
            int result = FuzzyDate.compare(ficheMeta1.getModificationDate(), ficheMeta2.getModificationDate());
            if (result == 0 && (result = FuzzyDate.compare(ficheMeta1.getCreationDate(), ficheMeta2.getCreationDate())) == 0) {
                result = Comparators.compareId(ficheMeta1, ficheMeta2);
            }
            if (this.desc) {
                return -result;
            }
            return result;
        }
    }

    private static class LiaisonIdComparator
    implements Comparator<Liaison> {
        private LiaisonIdComparator() {
        }

        @Override
        public int compare(Liaison liaison1, Liaison liaison2) {
            return Comparators.compareId(liaison1.getSubsetItem(), liaison2.getSubsetItem());
        }
    }

    private static class FieldKeyComparator
    implements Comparator<FieldKey> {
        private FieldKeyComparator() {
        }

        @Override
        public int compare(FieldKey fieldKey1, FieldKey fieldKey2) {
            int weight2;
            int weight1 = Comparators.getWeight(fieldKey1);
            if (weight1 > (weight2 = Comparators.getWeight(fieldKey2))) {
                return -1;
            }
            if (weight1 < weight2) {
                return 1;
            }
            if (weight1 > 100) {
                return 0;
            }
            return fieldKey1.getFieldName().compareTo(fieldKey2.getFieldName());
        }
    }

    private static class SizeComparator
    implements Comparator<Subset> {
        private SizeComparator() {
        }

        @Override
        public int compare(Subset subset1, Subset subset2) {
            int size2;
            int size1 = subset1.size();
            if (size1 > (size2 = subset2.size())) {
                return -1;
            }
            if (size1 < size2) {
                return 1;
            }
            return subset1.getSubsetKey().compareTo(subset2.getSubsetKey());
        }
    }

    private static class RedacteurComparator
    implements Comparator<Redacteur> {
        private RedacteurComparator() {
        }

        @Override
        public int compare(Redacteur r1, Redacteur r2) {
            String nc2;
            String id2;
            String id1 = r1.getLogin();
            int result = id1.compareTo(id2 = r2.getLogin());
            if (result != 0) {
                return result;
            }
            String nc1 = r1.getPersonCore().toDirectoryStyle(true);
            result = nc1.compareTo(nc2 = r2.getPersonCore().toDirectoryStyle(true));
            if (result != 0) {
                return result;
            }
            return r1.getSubsetKey().compareTo(r2.getSubsetKey());
        }
    }

    private static class ExternalItemIdComparator
    implements Comparator<ExternalItem> {
        private final boolean desc;

        private ExternalItemIdComparator(boolean desc) {
            this.desc = desc;
        }

        @Override
        public int compare(ExternalItem item1, ExternalItem item2) {
            int result = this.innerCompare(item1, item2);
            if (this.desc) {
                return -result;
            }
            return result;
        }

        private int innerCompare(ExternalItem item1, ExternalItem item2) {
            if (item1 instanceof ExternalItem.Id) {
                if (item2 instanceof ExternalItem.Id) {
                    return this.compareId((ExternalItem.Id)item1, (ExternalItem.Id)item2);
                }
                return -1;
            }
            if (item2 instanceof ExternalItem.Id) {
                return 1;
            }
            return this.compareIdalpha((ExternalItem.Idalpha)item1, (ExternalItem.Idalpha)item2);
        }

        private int compareId(ExternalItem.Id item1, ExternalItem.Id item2) {
            int id2;
            int id1 = item1.getId();
            if (id1 < (id2 = item2.getId())) {
                return -1;
            }
            if (id1 > id2) {
                return 1;
            }
            return 0;
        }

        private int compareIdalpha(ExternalItem.Idalpha item1, ExternalItem.Idalpha item2) {
            return item1.getIdalpha().compareTo(item2.getIdalpha());
        }
    }
}

