/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.selection;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.selection.PeriodCondition;
import net.fichotheque.utils.CorpusMetadataUtils;
import net.mapeadores.util.primitives.FuzzyDate;

public class PeriodConditionBuilder {
    private String startType = "any";
    private FuzzyDate startDate = null;
    private String endType = "same";
    private FuzzyDate endDate = null;
    private boolean onCreationDate = false;
    private boolean onModificationDate = false;
    private final Set<FieldKey> fieldKeySet = new LinkedHashSet<FieldKey>();

    public PeriodConditionBuilder setAnyStartDate() {
        this.startType = "any";
        this.startDate = null;
        return this;
    }

    public PeriodConditionBuilder setStartDate(FuzzyDate startDate) {
        if (startDate == null) {
            throw new IllegalArgumentException("startDate is null");
        }
        this.startType = "date";
        this.startDate = startDate;
        return this;
    }

    public PeriodConditionBuilder setAnyEndDate() {
        this.endType = "any";
        this.endDate = null;
        return this;
    }

    public PeriodConditionBuilder setSameEndDate() {
        this.endType = "same";
        this.endDate = null;
        return this;
    }

    public PeriodConditionBuilder setEndDate(FuzzyDate endDate) {
        if (endDate == null) {
            throw new IllegalArgumentException("endDate is null");
        }
        this.endType = "date";
        this.endDate = endDate;
        return this;
    }

    public PeriodConditionBuilder setOnCreationDate(boolean onCreationDate) {
        this.onCreationDate = onCreationDate;
        return this;
    }

    public PeriodConditionBuilder setOnModificationDate(boolean onModificationDate) {
        this.onModificationDate = onModificationDate;
        return this;
    }

    public PeriodConditionBuilder addFieldKey(FieldKey fieldKey) {
        this.fieldKeySet.add(fieldKey);
        return this;
    }

    public PeriodConditionBuilder addFieldKeys(Collection<FieldKey> fieldKeys) {
        this.fieldKeySet.addAll(fieldKeys);
        return this;
    }

    public PeriodCondition toPeriodCondition() {
        List<FieldKey> fieldKeyList = this.fieldKeySet.isEmpty() ? CorpusMetadataUtils.EMPTY_FIELDKEYLIST : CorpusMetadataUtils.wrap(this.fieldKeySet.toArray(new FieldKey[this.fieldKeySet.size()]));
        return new InternalPeriodCondition(this.startType, this.startDate, this.endType, this.endDate, this.onCreationDate, this.onModificationDate, fieldKeyList);
    }

    public static PeriodConditionBuilder init() {
        return new PeriodConditionBuilder();
    }

    private static class InternalPeriodCondition
    implements PeriodCondition {
        private final String startType;
        private final FuzzyDate startDate;
        private final String endType;
        private final FuzzyDate endDate;
        private final boolean onCreationDate;
        private final boolean onModificationDate;
        private final List<FieldKey> fieldKeyList;

        private InternalPeriodCondition(String startType, FuzzyDate startDate, String endType, FuzzyDate endDate, boolean onCreationDate, boolean onModificationDate, List<FieldKey> fieldKeyList) {
            this.startType = startType;
            this.startDate = startDate;
            this.endType = endType;
            this.endDate = endDate;
            this.onCreationDate = onCreationDate;
            this.onModificationDate = onModificationDate;
            this.fieldKeyList = fieldKeyList;
        }

        @Override
        public String getStartType() {
            return this.startType;
        }

        @Override
        public FuzzyDate getStartDate() {
            return this.startDate;
        }

        @Override
        public String getEndType() {
            return this.endType;
        }

        @Override
        public FuzzyDate getEndDate() {
            return this.endDate;
        }

        @Override
        public boolean isOnCreationDate() {
            return this.onCreationDate;
        }

        @Override
        public boolean isOnModificationDate() {
            return this.onModificationDate;
        }

        @Override
        public List<FieldKey> getFieldKeyList() {
            return this.fieldKeyList;
        }
    }
}

