/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.reponderation;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.fichotheque.SubsetKey;
import net.mapeadores.util.text.StringUtils;

public class ReponderationParameters {
    private final Set<Integer> idSet = new HashSet<Integer>();
    private final List<Integer> idList = new ArrayList<Integer>();
    private final SubsetKey originSubsetKey;
    private final SubsetKey croisementSubsetKey;
    private String oldMode = "";
    private String newMode = "";
    private int oldPoids = -1;
    private int newPoids = -1;

    public ReponderationParameters(SubsetKey corpusKey, SubsetKey croisementSubsetKey) {
        this.originSubsetKey = corpusKey;
        this.croisementSubsetKey = croisementSubsetKey;
    }

    public SubsetKey getOriginSubsetKey() {
        return this.originSubsetKey;
    }

    public SubsetKey getCroisementSubsetKey() {
        return this.croisementSubsetKey;
    }

    public String getOldMode() {
        return this.oldMode;
    }

    public void setOldMode(String oldMode) throws ParseException {
        if (oldMode.length() > 0) {
            StringUtils.checkTechnicalName(oldMode, false);
        }
        this.oldMode = oldMode;
    }

    public String getNewMode() {
        return this.newMode;
    }

    public void setNewMode(String newMode) throws ParseException {
        if (newMode.length() > 0) {
            StringUtils.checkTechnicalName(newMode, false);
        }
        this.newMode = newMode;
    }

    public int getOldPoids() {
        return this.oldPoids;
    }

    public void setOldPoids(int oldPoids) {
        this.oldPoids = oldPoids < 1 ? -1 : oldPoids;
    }

    public int getNewPoids() {
        return this.newPoids;
    }

    public void setNewPoids(int newPoids) {
        this.newPoids = newPoids < 1 ? -1 : newPoids;
    }

    public void addOriginId(int id) {
        if (id < 1) {
            throw new IllegalArgumentException("id < 1");
        }
        if (!this.idSet.contains(id)) {
            this.idSet.add(id);
            this.idList.add(id);
        }
    }

    public int getOriginIdCount() {
        return this.idList.size();
    }

    public int getOriginId(int i) {
        return this.idList.get(i);
    }
}

