/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.span;

import net.fichotheque.tools.parsers.span.BracketsParser;
import net.fichotheque.tools.parsers.span.EmphasisParser;
import net.fichotheque.tools.parsers.span.HttpParser;
import net.fichotheque.tools.parsers.span.SpanParseResult;
import net.fichotheque.tools.parsers.span.WwwParser;
import net.mapeadores.util.text.TypoOptions;

public abstract class SpanParser {
    SpanParser() {
    }

    public static SpanParser getEmphasisParser(TypoOptions typoOptions) {
        return new EmphasisParser(typoOptions);
    }

    public static SpanParser getBracketsParser(TypoOptions typoOptions) {
        return new BracketsParser(typoOptions);
    }

    public static SpanParser getHttpParser() {
        return new HttpParser();
    }

    public static SpanParser getWwwParser() {
        return new WwwParser();
    }

    public abstract SpanParseResult parse(String var1, int var2);

    public abstract char getStartChar();

    static boolean checkCharInUrl(char c) {
        if (c < '#' || c > '~') {
            return false;
        }
        if (c == '#') {
            return true;
        }
        if (c == '%') {
            return true;
        }
        if (c == '&') {
            return true;
        }
        if (c == '+') {
            return true;
        }
        if (c == '-') {
            return true;
        }
        if (c >= '/' && c <= ':') {
            return true;
        }
        if (c == '=') {
            return true;
        }
        if (c >= '@' && c <= 'Z') {
            return true;
        }
        if (c == '_') {
            return true;
        }
        if (c >= 'a' && c <= 'z') {
            return true;
        }
        return c == '~';
    }

    static int appendUrl(String source, StringBuilder buftexte, int beginIndex) {
        int length = source.length();
        int stopIndex = beginIndex - 1;
        for (int i = beginIndex; i < length; ++i) {
            char suivant;
            char c = source.charAt(i);
            if (c == '?') {
                if (i == length - 1 || !SpanParser.checkCharInUrl(suivant = source.charAt(i + 1))) break;
                buftexte.append('?');
            } else if (c == '.') {
                if (i == length - 1) break;
                suivant = source.charAt(i + 1);
                if (suivant == '.') {
                    buftexte.append("..");
                } else {
                    if (!SpanParser.checkCharInUrl(suivant)) break;
                    buftexte.append('.');
                }
            } else {
                if (!SpanParser.checkCharInUrl(c)) break;
                buftexte.append(c);
            }
            stopIndex = ++i;
        }
        return stopIndex;
    }

    static String getValue(String source, int beginIndex, int stopIndex, char stopChar) {
        StringBuilder buf = new StringBuilder();
        for (int i = beginIndex; i < stopIndex; ++i) {
            char next;
            char carac = source.charAt(i);
            if (i == beginIndex && carac == ' ') continue;
            if (carac == '\\' && i < stopIndex - 1 && ((next = source.charAt(i + 1)) == stopChar || next == '\\')) {
                buf.append(next);
                ++i;
                continue;
            }
            buf.append(carac);
        }
        return buf.toString();
    }

    static int getStopIndex(String source, int beginIndex, char stopChar) {
        int length = source.length();
        for (int i = beginIndex; i < length; ++i) {
            char carac = source.charAt(i);
            if (carac == stopChar) {
                return i;
            }
            if (carac != '\\') continue;
            ++i;
        }
        return -1;
    }
}

