/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.span;

import net.fichotheque.corpus.fiche.S;
import net.fichotheque.tools.parsers.span.SpanParseResult;
import net.fichotheque.tools.parsers.span.SpanParser;

class HttpParser
extends SpanParser {
    HttpParser() {
    }

    @Override
    public char getStartChar() {
        return 'h';
    }

    @Override
    public SpanParseResult parse(String source, int startIndex) {
        char prems;
        int length = source.length();
        boolean isHttps = false;
        if (startIndex > length - 10) {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        int currentIndex = startIndex + 1;
        if (source.charAt(currentIndex) != 't') {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        if (source.charAt(++currentIndex) != 't') {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        if (source.charAt(++currentIndex) != 'p') {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        if (source.charAt(++currentIndex) == 's') {
            isHttps = true;
            ++currentIndex;
        }
        if (source.charAt(currentIndex) != ':') {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        if (source.charAt(++currentIndex) != '/') {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        if (source.charAt(++currentIndex) != '/') {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        if ((prems = source.charAt(++currentIndex)) == '.' || prems == '?' || !HttpParser.checkCharInUrl(prems)) {
            return SpanParseResult.IGNORE_RESULT_1;
        }
        ++currentIndex;
        StringBuilder refBuffer = new StringBuilder();
        if (isHttps) {
            refBuffer.append("https://");
        } else {
            refBuffer.append("http://");
        }
        refBuffer.append(prems);
        int stopIndex = HttpParser.appendUrl(source, refBuffer, currentIndex);
        S span = new S(3);
        String ref = refBuffer.toString();
        span.setRef(ref);
        String value = isHttps ? ref.substring(8) : ref.substring(7);
        span.setValue(value);
        return new SpanParseResult(span, stopIndex);
    }
}

