/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers.croisement;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.fichotheque.ExistingIdException;
import net.fichotheque.FichothequeEditor;
import net.fichotheque.album.Album;
import net.fichotheque.album.AlbumEditor;
import net.fichotheque.album.Illustration;
import net.fichotheque.tools.croisement.LienBuffer;
import net.fichotheque.utils.AlbumUtils;
import net.mapeadores.util.exceptions.NestedIOException;
import net.mapeadores.util.exceptions.ShouldNotOccurException;
import net.mapeadores.util.images.ImagesUtils;
import net.mapeadores.util.logging.ErrorMessageException;
import net.mapeadores.util.request.FileValue;

class IllustrationMultipartToken {
    private final Album album;
    private final String extension;
    private final String mode;
    private final int poids;
    private final FileValue fileValue;

    IllustrationMultipartToken(Album album, String extension, String mode, int poids, FileValue fileValue) {
        this.album = album;
        this.extension = extension;
        this.mode = mode;
        this.poids = poids > 1 ? poids : 1;
        this.fileValue = fileValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    LienBuffer createIllustration(FichothequeEditor fichothequeEditor) {
        InputStream is;
        Illustration illustration;
        short formatType;
        AlbumEditor albumEditor = fichothequeEditor.getAlbumEditor(this.album);
        if (albumEditor == null) {
            return null;
        }
        File tmpFile = null;
        if (AlbumUtils.isPngConvertible(this.extension)) {
            formatType = 2;
            try (InputStream is2 = this.fileValue.getInputStream();){
                BufferedImage srcImg = ImagesUtils.read(is2);
                tmpFile = File.createTempFile("upload", "png");
                ImagesUtils.write(srcImg, "png", tmpFile);
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            catch (ErrorMessageException eme) {
                tmpFile = null;
            }
            finally {
                this.fileValue.free();
            }
            if (tmpFile == null) {
                return null;
            }
        } else {
            formatType = AlbumUtils.formatTypeToShort(this.extension);
        }
        try {
            illustration = albumEditor.createIllustration(-1, formatType);
        }
        catch (ExistingIdException eie) {
            throw new ShouldNotOccurException(eie);
        }
        if (tmpFile != null) {
            try {
                is = new FileInputStream(tmpFile);
                try {
                    albumEditor.updateIllustration(illustration, is, formatType);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            catch (ErrorMessageException ioe) {
            }
            finally {
                tmpFile.delete();
            }
        } else {
            try {
                is = this.fileValue.getInputStream();
                try {
                    albumEditor.updateIllustration(illustration, is, formatType);
                }
                finally {
                    if (is != null) {
                        is.close();
                    }
                }
            }
            catch (IOException ioe) {
                throw new NestedIOException(ioe);
            }
            catch (ErrorMessageException errorMessageException) {
            }
            finally {
                this.fileValue.free();
            }
        }
        return new LienBuffer(illustration, this.mode, this.poids);
    }
}

