/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.parsers;

import java.text.ParseException;
import net.fichotheque.corpus.Corpus;
import net.fichotheque.corpus.FicheChange;
import net.fichotheque.corpus.FicheMeta;
import net.fichotheque.corpus.fiche.Fiche;
import net.fichotheque.corpus.metadata.CorpusField;
import net.fichotheque.corpus.metadata.CorpusMetadata;
import net.fichotheque.corpus.metadata.FieldKey;
import net.fichotheque.corpus.metadata.SubfieldKey;
import net.fichotheque.tools.corpus.FicheChangeBuilder;
import net.fichotheque.tools.parsers.FicheParser;
import net.fichotheque.utils.CorpusUtils;
import net.mapeadores.util.request.RequestMap;

public class FicheParseEngine {
    public static final short NONE_TYPE = 0;
    public static final short REPLACE_TYPE = 1;
    public static final short UPDATE_TYPE = 2;

    private FicheParseEngine() {
    }

    public static Fiche run(FicheParser.Parameters ficheParserParameters, FicheMeta ficheMeta, RequestMap requestMap, short type) {
        Corpus corpus = ficheMeta.getCorpus();
        CorpusMetadata corpusMetadata = corpus.getCorpusMetadata();
        FicheChangeBuilder ficheChangeBuilder = new FicheChangeBuilder();
        FicheParser ficheParser = new FicheParser(ficheParserParameters, corpus, ficheChangeBuilder);
        for (String paramName : requestMap.getParameterNameSet()) {
            boolean subfieldDone = FicheParseEngine.parseSubfield(corpusMetadata, ficheParser, paramName, requestMap);
            if (subfieldDone) continue;
            FicheParseEngine.parseCorpusField(ficheParserParameters, corpusMetadata, ficheParser, paramName, requestMap);
        }
        ficheParser.flushParsedSubfields();
        FicheChange ficheChange = ficheChangeBuilder.toFicheChange();
        if (type == 1) {
            return CorpusUtils.toFiche(ficheChange);
        }
        Fiche originalFiche = ficheMeta.getCorpus().getFiche(ficheMeta);
        CorpusUtils.updateFiche(originalFiche, ficheChange);
        return originalFiche;
    }

    private static boolean parseCorpusField(FicheParser.Parameters ficheParseParameters, CorpusMetadata corpusMetadata, FicheParser ficheParser, String paramName, RequestMap requestMap) {
        try {
            FieldKey fieldKey = FieldKey.parse(paramName);
            CorpusField corpusField = corpusMetadata.getCorpusField(fieldKey);
            if (corpusField != null) {
                String value = FicheParseEngine.concatParameterValues(ficheParseParameters, corpusField, paramName, requestMap);
                ficheParser.parseCorpusField(corpusField, value);
            }
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    private static boolean parseSubfield(CorpusMetadata corpusMetadata, FicheParser ficheParser, String paramName, RequestMap requestMap) {
        try {
            SubfieldKey subfieldKey = SubfieldKey.parse(paramName);
            FieldKey fieldKey = subfieldKey.getFieldKey();
            CorpusField corpusField = corpusMetadata.getCorpusField(fieldKey);
            if (corpusField != null) {
                String value = requestMap.getParameter(paramName);
                ficheParser.parseSubfield(corpusField, subfieldKey, value);
            }
            return true;
        }
        catch (ParseException pe) {
            return false;
        }
    }

    private static String concatParameterValues(FicheParser.Parameters ficheParseParameters, CorpusField corpusField, String paramName, RequestMap requestMap) {
        char delimiter = FicheParseEngine.getDelimiter(ficheParseParameters, corpusField);
        String[] paramValues = requestMap.getParameterValues(paramName);
        int length = paramValues.length;
        if (length == 1) {
            return paramValues[0];
        }
        StringBuilder buf = new StringBuilder();
        buf.append(paramValues[0]);
        for (int i = 1; i < length; ++i) {
            if (delimiter != '\u0000') {
                buf.append(delimiter);
            }
            buf.append(paramValues[i]);
        }
        return buf.toString();
    }

    private static char getDelimiter(FicheParser.Parameters ficheParseParameters, CorpusField corpusField) {
        switch (corpusField.getCategory()) {
            case 2: {
                return ficheParseParameters.getItemListSeparateur();
            }
            case 3: {
                return '\n';
            }
            case 0: {
                switch (corpusField.getFieldString()) {
                    case "redacteurs": {
                        return ficheParseParameters.getItemListSeparateur();
                    }
                }
            }
        }
        return '\u0000';
    }
}

