/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.text.ParseException;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.ThesaurusRowParser;
import net.fichotheque.tools.importation.thesaurus.MoveThesaurusImportBuilder;

class ThesaurusMoveRowParser
extends ThesaurusRowParser {
    private final int fieldIndex;
    private final boolean isIdalpha;
    private final MoveThesaurusImportBuilder moveThesaurusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;

    private ThesaurusMoveRowParser(MoveThesaurusImportBuilder moveThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, int fieldIndex, boolean isIdalpha) {
        this.moveThesaurusImportBuilder = moveThesaurusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.fieldIndex = fieldIndex;
        this.isIdalpha = isIdalpha;
    }

    @Override
    public MoveThesaurusImportBuilder getThesaurusImportBuilder() {
        return this.moveThesaurusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        if (row.getColumnCount() <= this.fieldIndex) {
            this.parseResultBuilder.addParseError("MISSING ID COLUMN", rowNumber);
            return;
        }
        String idString = row.getColumnValue(this.fieldIndex).trim();
        Thesaurus thesaurus = this.moveThesaurusImportBuilder.getThesaurus();
        Motcle motcle = null;
        if (this.isIdalpha) {
            motcle = thesaurus.getMotcleByIdalpha(idString);
            if (motcle == null) {
                this.parseResultBuilder.addBdfError("UNKNOWN IDALPHA", idString, rowNumber);
            }
        } else {
            try {
                int id = Integer.parseInt(idString);
                motcle = thesaurus.getMotcleById(id);
                if (motcle == null) {
                    this.parseResultBuilder.addBdfError("UNKNOWN ID", idString, rowNumber);
                }
            }
            catch (NumberFormatException nfe) {
                this.parseResultBuilder.addBdfError("NOT INTEGER", idString, rowNumber);
            }
        }
        if (motcle != null) {
            this.moveThesaurusImportBuilder.add(motcle);
        }
    }

    static ThesaurusMoveRowParser newInstance(String[] fieldArray, MoveThesaurusImportBuilder moveThesaurusImportBuilder, ParseResultBuilder parseResultBuilder) {
        int fieldIndex = -1;
        int idalphaIndex = -1;
        int length = fieldArray.length;
        for (int i = 0; i < length; ++i) {
            ThesaurusFieldKey thesaurusFieldKey;
            String field = fieldArray[i].trim();
            try {
                thesaurusFieldKey = ThesaurusFieldKey.parse(field);
            }
            catch (ParseException pe) {
                continue;
            }
            if (thesaurusFieldKey.equals(ThesaurusFieldKey.ID)) {
                if (fieldIndex != -1) continue;
                fieldIndex = i;
                continue;
            }
            if (!thesaurusFieldKey.equals(ThesaurusFieldKey.IDALPHA) || idalphaIndex != -1) continue;
            idalphaIndex = i;
        }
        boolean isIdalpha = false;
        if (fieldIndex == -1) {
            if (moveThesaurusImportBuilder.getThesaurus().isIdalphaType()) {
                if (idalphaIndex != -1) {
                    fieldIndex = idalphaIndex;
                    isIdalpha = true;
                } else {
                    parseResultBuilder.addInitError("MISSING FIELDS INIT", "(" + ThesaurusFieldKey.ID.toString() + " || " + ThesaurusFieldKey.IDALPHA.toString() + ")");
                }
            } else {
                parseResultBuilder.addInitError("MISSING FIELDS INIT", ThesaurusFieldKey.ID.toString());
            }
        }
        if (fieldIndex != -1) {
            return new ThesaurusMoveRowParser(moveThesaurusImportBuilder, parseResultBuilder, fieldIndex, isIdalpha);
        }
        return null;
    }
}

