/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import java.util.HashSet;
import java.util.Set;
import net.fichotheque.FichothequeConstants;
import net.fichotheque.importation.ParentChange;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.BdfErrorException;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.ThesaurusColumns;
import net.fichotheque.tools.importation.parsers.ThesaurusRowParser;
import net.fichotheque.tools.importation.parsers.handlers.HandlerUtils;
import net.fichotheque.tools.importation.parsers.handlers.IdalphaHandler;
import net.fichotheque.tools.importation.thesaurus.EditMotcleImportBuilder;
import net.fichotheque.tools.importation.thesaurus.EditThesaurusImportBuilder;
import net.fichotheque.utils.ParentChangeUtils;

class ThesaurusCreationRowParser
extends ThesaurusRowParser {
    private final EditThesaurusImportBuilder editThesaurusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;
    private final ThesaurusColumns thesaurusColumns;
    private final Set<String> idalphaSet;
    private final Set<Integer> idSet;

    private ThesaurusCreationRowParser(EditThesaurusImportBuilder editThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, ThesaurusColumns thesaurusColumns) {
        this.editThesaurusImportBuilder = editThesaurusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.thesaurusColumns = thesaurusColumns;
        this.idSet = thesaurusColumns.getIdIndex() != -1 ? new HashSet<Integer>() : null;
        this.idalphaSet = thesaurusColumns.getIdalphaHandler() != null ? new HashSet<String>() : null;
    }

    @Override
    public EditThesaurusImportBuilder getThesaurusImportBuilder() {
        return this.editThesaurusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        String statusString;
        Thesaurus thesaurus = this.editThesaurusImportBuilder.getThesaurus();
        int columnCount = row.getColumnCount();
        int idIndex = this.thesaurusColumns.getIdIndex();
        int newId = -1;
        boolean withFatalError = false;
        if (idIndex != -1 && idIndex < columnCount) {
            String idString = row.getColumnValue(idIndex).trim();
            try {
                newId = Integer.parseInt(idString);
                if (newId < 1) {
                    newId = -1;
                } else if (thesaurus.getMotcleById(newId) != null) {
                    this.parseResultBuilder.addBdfError("EXISTING ID", idString, rowNumber);
                    newId = -1;
                } else {
                    this.idSet.add(newId);
                }
            }
            catch (NumberFormatException nfe) {
                this.parseResultBuilder.addBdfError("NOT INTEGER", idString, rowNumber);
            }
        }
        IdalphaHandler idalphaHandler = this.thesaurusColumns.getIdalphaHandler();
        String newIdalpha = null;
        if (idalphaHandler != null) {
            try {
                newIdalpha = idalphaHandler.getIdalpha(row, true);
                if (thesaurus.getMotcleByIdalpha(newIdalpha) != null) {
                    this.parseResultBuilder.addBdfError("EXISTING IDALPHA", newIdalpha, rowNumber);
                    withFatalError = true;
                } else {
                    this.idalphaSet.add(newIdalpha);
                }
            }
            catch (BdfErrorException bee) {
                this.parseResultBuilder.addBdfError(bee.getKey(), bee.getKey(), rowNumber);
                withFatalError = true;
            }
        }
        ParentChange parentChange = null;
        int parentIdIndex = this.thesaurusColumns.getParentIdIndex();
        IdalphaHandler parentIdalphaHandler = this.thesaurusColumns.getParentIdalphaHandler();
        if (parentIdIndex != -1) {
            String parentIdString;
            if (parentIdIndex < columnCount && (parentIdString = row.getColumnValue(parentIdIndex).trim()).length() > 0) {
                try {
                    int parentId = Integer.parseInt(parentIdString);
                    if (parentId < 1) {
                        parentId = -1;
                    } else if (thesaurus.getMotcleById(parentId) == null && !this.idSet.contains(parentId)) {
                        this.parseResultBuilder.addBdfError("UNKNOWN ID", parentIdString, rowNumber);
                        parentId = -1;
                    } else if (parentId == newId) {
                        this.parseResultBuilder.addBdfError("SELF PARENT", parentIdString, rowNumber);
                        parentId = -1;
                    }
                    if (parentId > 0) {
                        parentChange = ParentChangeUtils.toIdParentChange(parentId);
                    }
                }
                catch (NumberFormatException nfe) {
                    this.parseResultBuilder.addBdfError("NOT INTEGER", parentIdString, rowNumber);
                }
            }
        } else if (parentIdalphaHandler != null) {
            try {
                String parentIdalpha = parentIdalphaHandler.getIdalpha(row, false);
                if (parentIdalpha != null) {
                    if (thesaurus.getMotcleByIdalpha(parentIdalpha) == null && !this.idalphaSet.contains(parentIdalpha)) {
                        this.parseResultBuilder.addBdfError("UNKNOWN IDALPHA", parentIdalpha, rowNumber);
                        parentIdalpha = null;
                    } else if (parentIdalpha.equals(newIdalpha)) {
                        this.parseResultBuilder.addBdfError("SELF PARENT", parentIdalpha, rowNumber);
                        parentIdalpha = null;
                    }
                }
                if (parentIdalpha != null) {
                    parentChange = ParentChangeUtils.toIdalphaParentChange(parentIdalpha);
                }
            }
            catch (BdfErrorException bee) {
                this.parseResultBuilder.addBdfError(bee.getKey(), bee.getKey(), rowNumber);
            }
        }
        if (withFatalError) {
            return;
        }
        EditMotcleImportBuilder motcleImportBuilder = this.editThesaurusImportBuilder.getEditMotcleImportBuilder(newId, newIdalpha);
        motcleImportBuilder.setParent(parentChange);
        int statusIndex = this.thesaurusColumns.getStatusIndex();
        if (statusIndex != -1 && !(statusString = row.getColumnValue(statusIndex).trim()).isEmpty()) {
            try {
                motcleImportBuilder.setNewStatus(FichothequeConstants.checkMotcleStatus(statusString));
            }
            catch (IllegalArgumentException iae) {
                this.parseResultBuilder.addBdfError("UNKNOWN STATUS", statusString, rowNumber);
            }
        }
        if (this.thesaurusColumns.hasLabelHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getLabelChangeBuilder(), this.thesaurusColumns.getLabelHandlerArray(), row, this.parseResultBuilder, rowNumber);
        }
        if (this.thesaurusColumns.hasAttributeHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getAttributeChangeBuilder(), this.thesaurusColumns.getAttributeHandlerArray(), row);
        }
        if (this.thesaurusColumns.hasCroisementHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getLiensImportBuilder(), this.thesaurusColumns.getCroisementHandlers(), row, thesaurus, null, null, null);
        }
    }

    static ThesaurusCreationRowParser newInstance(String[] fieldArray, EditThesaurusImportBuilder editThesaurusImportBuilder, ParseResultBuilder parseResultBuilder) {
        ThesaurusColumns thesaurusColumns = ThesaurusColumns.parse(fieldArray, editThesaurusImportBuilder, parseResultBuilder);
        if (editThesaurusImportBuilder.getThesaurus().isIdalphaType() && thesaurusColumns.getIdalphaHandler() == null) {
            parseResultBuilder.addInitError("MISSING FIELDS INIT", ThesaurusFieldKey.IDALPHA.toString());
            return null;
        }
        return new ThesaurusCreationRowParser(editThesaurusImportBuilder, parseResultBuilder, thesaurusColumns);
    }
}

