/*
 * Decompiled with CFR 0.152.
 */
package net.fichotheque.tools.importation.parsers;

import net.fichotheque.FichothequeConstants;
import net.fichotheque.importation.ParentChange;
import net.fichotheque.thesaurus.Motcle;
import net.fichotheque.thesaurus.Thesaurus;
import net.fichotheque.thesaurus.metadata.ThesaurusFieldKey;
import net.fichotheque.tools.importation.ParseResultBuilder;
import net.fichotheque.tools.importation.parsers.BdfErrorException;
import net.fichotheque.tools.importation.parsers.Row;
import net.fichotheque.tools.importation.parsers.ThesaurusColumns;
import net.fichotheque.tools.importation.parsers.ThesaurusRowParser;
import net.fichotheque.tools.importation.parsers.handlers.HandlerUtils;
import net.fichotheque.tools.importation.parsers.handlers.IdalphaHandler;
import net.fichotheque.tools.importation.thesaurus.EditMotcleImportBuilder;
import net.fichotheque.tools.importation.thesaurus.EditThesaurusImportBuilder;
import net.fichotheque.utils.ParentChangeUtils;

class ThesaurusChangeRowParser
extends ThesaurusRowParser {
    private final EditThesaurusImportBuilder editThesaurusImportBuilder;
    private final ParseResultBuilder parseResultBuilder;
    private final ThesaurusColumns thesaurusColumns;

    ThesaurusChangeRowParser(EditThesaurusImportBuilder editThesaurusImportBuilder, ParseResultBuilder parseResultBuilder, ThesaurusColumns thesaurusColumns) {
        this.editThesaurusImportBuilder = editThesaurusImportBuilder;
        this.parseResultBuilder = parseResultBuilder;
        this.thesaurusColumns = thesaurusColumns;
    }

    @Override
    public EditThesaurusImportBuilder getThesaurusImportBuilder() {
        return this.editThesaurusImportBuilder;
    }

    @Override
    public void parseRow(int rowNumber, Row row) {
        String statusString;
        ParentChange parentChange;
        String newIdalpha;
        EditMotcleImportBuilder motcleImportBuilder;
        Thesaurus thesaurus;
        block39: {
            thesaurus = this.editThesaurusImportBuilder.getThesaurus();
            int columnCount = row.getColumnCount();
            int idIndex = this.thesaurusColumns.getIdIndex();
            IdalphaHandler idalphaHandler = this.thesaurusColumns.getIdalphaHandler();
            Motcle motcle = null;
            if (idIndex != -1) {
                if (columnCount <= idIndex) {
                    this.parseResultBuilder.addParseError("MISSING ID COLUMN", rowNumber);
                    return;
                }
                String idString = row.getColumnValue(idIndex).trim();
                try {
                    int id = Integer.parseInt(idString);
                    motcle = thesaurus.getMotcleById(id);
                    if (motcle == null) {
                        this.parseResultBuilder.addBdfError("UNKNOWN ID", idString, rowNumber);
                    }
                }
                catch (NumberFormatException nfe) {
                    this.parseResultBuilder.addBdfError("NOT INTEGER", idString, rowNumber);
                }
            } else {
                try {
                    String idalpha = idalphaHandler.getIdalpha(row, true);
                    motcle = thesaurus.getMotcleByIdalpha(idalpha);
                    if (motcle == null) {
                        this.parseResultBuilder.addBdfError("UNKNOWN IDALPHA", idalpha, rowNumber);
                    }
                }
                catch (BdfErrorException bee) {
                    this.parseResultBuilder.addBdfError(bee.getKey(), bee.getKey(), rowNumber);
                }
            }
            if (motcle == null) {
                return;
            }
            motcleImportBuilder = this.editThesaurusImportBuilder.getEditMotcleImportBuilder(motcle);
            newIdalpha = null;
            if (idIndex != -1 && idalphaHandler != null) {
                try {
                    newIdalpha = idalphaHandler.getIdalpha(row, false);
                    if (newIdalpha != null && thesaurus.getMotcleByIdalpha(newIdalpha) != null) {
                        newIdalpha = null;
                        this.parseResultBuilder.addBdfError("EXISTING IDALPHA", newIdalpha, rowNumber);
                    }
                }
                catch (BdfErrorException bee) {
                    this.parseResultBuilder.addBdfError(bee.getKey(), bee.getText(), rowNumber);
                }
            }
            parentChange = null;
            int parentIdIndex = this.thesaurusColumns.getParentIdIndex();
            IdalphaHandler parentIdalphaHandler = this.thesaurusColumns.getParentIdalphaHandler();
            if (parentIdIndex != -1) {
                if (parentIdIndex < columnCount) {
                    String parentIdString = row.getColumnValue(parentIdIndex).trim();
                    if (parentIdString.length() == 0) {
                        parentChange = ParentChangeUtils.THESAURUS;
                    } else {
                        try {
                            int parentId = Integer.parseInt(parentIdString);
                            if (parentId < 1) {
                                parentChange = ParentChangeUtils.THESAURUS;
                                break block39;
                            }
                            Motcle parentMotcle = thesaurus.getMotcleById(parentId);
                            if (parentMotcle == null) {
                                this.parseResultBuilder.addBdfError("UNKNOWN ID", parentIdString, rowNumber);
                                break block39;
                            }
                            parentChange = ParentChangeUtils.toIdParentChange(parentMotcle.getId());
                        }
                        catch (NumberFormatException nfe) {
                            this.parseResultBuilder.addBdfError("NOT INTEGER", parentIdString, rowNumber);
                        }
                    }
                } else {
                    parentChange = ParentChangeUtils.THESAURUS;
                }
            } else if (parentIdalphaHandler != null) {
                try {
                    String parentIdalpha = parentIdalphaHandler.getIdalpha(row, false);
                    if (parentIdalpha == null) {
                        parentChange = ParentChangeUtils.THESAURUS;
                    } else {
                        Motcle parentMotcle = thesaurus.getMotcleByIdalpha(parentIdalpha);
                        if (parentMotcle == null) {
                            this.parseResultBuilder.addBdfError("EXISTING IDALPHA", newIdalpha, rowNumber);
                        } else {
                            parentChange = ParentChangeUtils.toIdParentChange(parentMotcle.getId());
                        }
                    }
                }
                catch (BdfErrorException bee) {
                    String key = bee.getKey();
                    if (key.equals("MALFORMED IDALPHA")) {
                        this.parseResultBuilder.addBdfError(key, bee.getText(), rowNumber);
                    }
                    parentChange = ParentChangeUtils.THESAURUS;
                }
            }
        }
        int statusIndex = this.thesaurusColumns.getStatusIndex();
        if (statusIndex != -1 && !(statusString = row.getColumnValue(statusIndex).trim()).isEmpty()) {
            try {
                motcleImportBuilder.setNewStatus(FichothequeConstants.checkMotcleStatus(statusString));
            }
            catch (IllegalArgumentException iae) {
                this.parseResultBuilder.addBdfError("UNKNOWN STATUS", statusString, rowNumber);
            }
        }
        motcleImportBuilder.setNewIdalpha(newIdalpha).setParent(parentChange);
        if (this.thesaurusColumns.hasLabelHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getLabelChangeBuilder(), this.thesaurusColumns.getLabelHandlerArray(), row, this.parseResultBuilder, rowNumber);
        }
        if (this.thesaurusColumns.hasAttributeHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getAttributeChangeBuilder(), this.thesaurusColumns.getAttributeHandlerArray(), row);
        }
        if (this.thesaurusColumns.hasCroisementHandler()) {
            HandlerUtils.populate(motcleImportBuilder.getLiensImportBuilder(), this.thesaurusColumns.getCroisementHandlers(), row, thesaurus, null, null, null);
        }
    }

    static ThesaurusChangeRowParser newInstance(String[] fieldArray, EditThesaurusImportBuilder editThesaurusImportBuilder, ParseResultBuilder parseResultBuilder) {
        ThesaurusColumns thesaurusColumns = ThesaurusColumns.parse(fieldArray, editThesaurusImportBuilder, parseResultBuilder);
        if (thesaurusColumns.getIdIndex() == -1 && thesaurusColumns.getIdalphaHandler() == null) {
            parseResultBuilder.addInitError("MISSING FIELDS INIT", ThesaurusFieldKey.ID.toString());
            return null;
        }
        return new ThesaurusChangeRowParser(editThesaurusImportBuilder, parseResultBuilder, thesaurusColumns);
    }
}

